/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.datatype.DataType;
import java.util.Arrays;

@Immutable
public class ComplexKey {
    private final Object[] myKeyObjects;

    public static ComplexKey createComplexKeyWithValues(Object ... keyObjects) {
        return new ComplexKey(keyObjects);
    }

    private ComplexKey(Object[] keyObjects) {
        if (keyObjects == null || keyObjects.length == 0) {
            throw new IllegalArgumentException("Parameter must be a non zero-length array");
        }
        this.myKeyObjects = keyObjects;
    }

    public int getKeyLength() {
        return this.myKeyObjects.length;
    }

    public Object getKeyObjectForIndex(int index) {
        if (index > this.myKeyObjects.length - 1 || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of range");
        }
        return this.myKeyObjects[index];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myKeyObjects);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexKey other = (ComplexKey)obj;
        return Arrays.equals(this.myKeyObjects, other.myKeyObjects);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Object keyObject : this.myKeyObjects) {
            builder.append("'");
            DataType dataType = DataType.fromObjectClass(keyObject);
            builder.append(dataType != null ? dataType.makeDisplayString(keyObject) : keyObject);
            builder.append("', ");
        }
        return builder.substring(0, builder.length() - 2);
    }
}

