/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dag;

import com.ericsson.ere.interfaces.Acceptable;
import com.ericsson.ere.interfaces.Visitor;
import ericsson.ere.interfaces.DAGNode;

public final class DAGVisit {
    private DAGVisit() {
    }

    public static <T extends Visitor, U extends DAGNode & Acceptable<? super T>> void visitPreOrder(U root, T visitor) {
        ((Acceptable<T>)root).accept(visitor);
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = root.getChildAt(i);
            DAGVisit.visitPreOrder(child, visitor);
        }
    }

    public static <T extends Visitor, U extends DAGNode & Acceptable<? super T>> void visitPostOrder(U root, T visitor) {
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = root.getChildAt(i);
            DAGVisit.visitPostOrder(child, visitor);
        }
        ((Acceptable<T>)root).accept(visitor);
    }

    public static <T extends Visitor, U extends DAGNode & Acceptable<? super T>> void visitPrePostOrder(U root, T visitor) {
        ((Acceptable<T>)root).accept(visitor);
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = root.getChildAt(i);
            DAGVisit.visitPrePostOrder(child, visitor);
        }
        ((Acceptable<T>)root).accept(visitor);
    }
}

