/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsSemanticVersion;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class IsSemanticVersionValidator
implements ConstraintValidator<IsSemanticVersion, String> {
    private static final Pattern SEM_VER_COMPLETE__PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern SEM_VER_CORE_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)$");
    private boolean onlyCoreVersion;

    @Override
    public void initialize(IsSemanticVersion annotation) {
        this.onlyCoreVersion = annotation.onlyCoreVersion();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.onlyCoreVersion && !SEM_VER_CORE_PATTERN.matcher(value).matches()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("{IsSemanticVersion.core_version_message}").addConstraintViolation();
            return false;
        }
        return SEM_VER_COMPLETE__PATTERN.matcher(value).matches();
    }
}

