/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsLongString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class IsLongStringValidator
implements ConstraintValidator<IsLongString, String> {
    private boolean allowPositiveValue = true;
    private boolean allowNegativeValue = true;

    @Override
    public void initialize(IsLongString paramA) {
        this.allowPositiveValue = paramA.allowPositiveValue();
        this.allowNegativeValue = paramA.allowNegativeValue();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        long longValue;
        if (value == null) {
            return true;
        }
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (!(this.allowPositiveValue ^ this.allowNegativeValue)) {
            return true;
        }
        if (this.allowPositiveValue) {
            return longValue >= 0L;
        }
        return longValue <= 0L;
    }
}

