/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsIntegerStringWithinRange;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class IsIntegerStringWithinRangeValidator
implements ConstraintValidator<IsIntegerStringWithinRange, String> {
    private int min;
    private int max;

    @Override
    public void initialize(IsIntegerStringWithinRange paramA) {
        this.min = paramA.min();
        this.max = paramA.max();
        this.validateParameters();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            int integer = Integer.parseInt(value);
            if (integer >= this.min && integer <= this.max) {
                return true;
            }
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("{IsIntegerWithinRange.message}").addConstraintViolation();
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void validateParameters() {
        if (this.max < this.min) {
            throw new IllegalArgumentException("Max should be greater than min.");
        }
    }
}

