/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsDateTime;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class IsDateTimeValidator
implements ConstraintValidator<IsDateTime, XMLGregorianCalendar> {
    private XMLGregorianCalendar minDateCalendar;

    @Override
    public void initialize(IsDateTime annotation) {
        try {
            this.minDateCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(annotation.minDate());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("minDate parameter is not a valid date. (yyyy-mm-dd)");
        }
    }

    @Override
    public boolean isValid(XMLGregorianCalendar value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return value.compare(this.minDateCalendar) >= 0;
    }
}

