/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsDateTimeString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class IsDateTimeStringValidator
implements ConstraintValidator<IsDateTimeString, String> {
    private IsDateTimeString.DATE_TIME_FORMAT format;
    private DateTime minDate;
    private DateTime date;

    @Override
    public void initialize(IsDateTimeString parameters) {
        this.format = parameters.format();
        this.minDate = ISODateTimeFormat.yearMonthDay().parseDateTime(parameters.minDate());
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (!this.isValidDateAndDateFormat(value)) {
            if (constraintValidatorContext != null) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate("{IsDateTimeString.Invalid_message}").addConstraintViolation();
            }
            return false;
        }
        return this.date.compareTo(this.minDate) >= 0;
    }

    private boolean isValidDateAndDateFormat(String value) {
        try {
            DateTimeFormatter sdf = DateTimeFormat.forPattern(this.format.getFormat());
            this.date = sdf.parseDateTime(value);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

