/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsDateString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class IsDateStringValidator
implements ConstraintValidator<IsDateString, String> {
    private IsDateString.DATE_FORMAT format;
    private DateTime minDate;
    private DateTime date;

    @Override
    public void initialize(IsDateString parameters) {
        this.format = parameters.format();
        this.minDate = ISODateTimeFormat.yearMonthDay().parseLocalDate(parameters.minDate()).toDateTimeAtStartOfDay();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (!this.isValidDateAndDateFormat(value)) {
            if (constraintValidatorContext != null) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate("{IsDateString.Invalid_message}").addConstraintViolation();
            }
            return false;
        }
        return this.date.compareTo(this.minDate) >= 0;
    }

    private boolean isValidDateAndDateFormat(String value) {
        try {
            DateTimeFormatter sdf = DateTimeFormat.forPattern(this.format.getFormat());
            this.date = sdf.parseLocalDate(value).toDateTimeAtStartOfDay();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

