/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.IndexOffset;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MaximumNumberOfEntries;
import com.ericsson.em.m3if.v1_0.common.Paging;
import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="timedpaginginfo", propOrder={"maximumNumberOfItems", "indexOffset", "dateTime"})
public class TimedPagingInfo
implements Serializable,
Paging {
    private static final long serialVersionUID = -1300184451692128027L;
    static final MaximumNumberOfEntries DEFAULT_MAXIMUM_NUMBER_OF_ITEMS = MaximumNumberOfEntries.fromInteger(50);
    static final IndexOffset DEFAULT_INDEX_OFFSET = IndexOffset.fromInteger(0);
    @Valid
    @XmlElement(name="maximumnumberofitems", defaultValue="50")
    private final MaximumNumberOfEntries maximumNumberOfItems;
    @Valid
    @XmlElement(name="indexoffset", defaultValue="0")
    private final IndexOffset indexOffset;
    @Valid
    @XmlElement(name="datetime", type=Iso8601DateTime.class)
    private Iso8601DateTime dateTime;

    protected TimedPagingInfo() {
        this.maximumNumberOfItems = DEFAULT_MAXIMUM_NUMBER_OF_ITEMS;
        this.indexOffset = DEFAULT_INDEX_OFFSET;
    }

    public TimedPagingInfo(MaximumNumberOfEntries maximumNumberOfItems, IndexOffset indexOffset) {
        this.maximumNumberOfItems = maximumNumberOfItems;
        this.indexOffset = indexOffset;
    }

    public TimedPagingInfo(MaximumNumberOfEntries maximumNumberOfItems, IndexOffset indexOffset, Iso8601DateTime dateTime) {
        this.maximumNumberOfItems = maximumNumberOfItems;
        this.indexOffset = indexOffset;
        this.dateTime = dateTime;
    }

    @Override
    public MaximumNumberOfEntries getMaximumNumberOfItems() {
        return this.maximumNumberOfItems;
    }

    @Override
    public IndexOffset getIndexOffset() {
        return this.indexOffset;
    }

    @Override
    public Optional<Iso8601DateTime> getDateTime() {
        return Optional.ofNullable(this.dateTime);
    }

    public static TimedPagingInfo fromDefaultValues() {
        return TimedPagingInfo.from(DEFAULT_MAXIMUM_NUMBER_OF_ITEMS, DEFAULT_INDEX_OFFSET);
    }

    public static TimedPagingInfo from(MaximumNumberOfEntries maximumNumberOfItems) {
        return TimedPagingInfo.from(maximumNumberOfItems, DEFAULT_INDEX_OFFSET);
    }

    public static TimedPagingInfo from(IndexOffset indexOffset) {
        return TimedPagingInfo.from(DEFAULT_MAXIMUM_NUMBER_OF_ITEMS, indexOffset);
    }

    public static TimedPagingInfo from(int maximumNumberOfItems, int indexOffset) {
        return Validation.validate(new TimedPagingInfo(MaximumNumberOfEntries.fromInteger(maximumNumberOfItems), IndexOffset.fromInteger(indexOffset)));
    }

    public static TimedPagingInfo from(MaximumNumberOfEntries maximumNumberOfItems, IndexOffset indexOffset) {
        return Validation.validate(new TimedPagingInfo(maximumNumberOfItems, indexOffset));
    }

    public static TimedPagingInfo fromPaging(Paging paging) {
        return new TimedPagingInfo(paging.getMaximumNumberOfItems(), paging.getIndexOffset(), paging.getDateTime().orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedPagingInfo that = (TimedPagingInfo)o;
        return Objects.equals(this.maximumNumberOfItems, that.maximumNumberOfItems) && Objects.equals(this.indexOffset, that.indexOffset) && Objects.equals(this.dateTime, that.dateTime);
    }

    public int hashCode() {
        return Objects.hash(this.maximumNumberOfItems, this.indexOffset, this.dateTime);
    }

    public String toString() {
        String asString = "{maximumNumberOfItems=" + String.valueOf(this.maximumNumberOfItems) + ", indexOffset=" + String.valueOf(this.indexOffset);
        asString = this.dateTime != null ? asString + ", dateTime=" + this.dateTime.toString() + "}" : asString + "}";
        return asString;
    }
}

