/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="personalidentificationnumber")
public class PersonalIdentificationNumberValue
implements Comparable<PersonalIdentificationNumberValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Length(max=32)
    @IsRestrictedString
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected PersonalIdentificationNumberValue() {
        this.value = null;
    }

    private PersonalIdentificationNumberValue(String personalIdentificationNumber) {
        this.value = personalIdentificationNumber;
    }

    public static PersonalIdentificationNumberValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new PersonalIdentificationNumberValue(value);
    }

    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(PersonalIdentificationNumberValue personalIdentificationNumber) {
        if (personalIdentificationNumber == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(personalIdentificationNumber.getValueAsString());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersonalIdentificationNumberValue other = (PersonalIdentificationNumberValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(PersonalIdentificationNumberValue o) {
        return this.value.compareTo(o.value);
    }
}

