/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsIso8601DateTime;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="iso8601datetime")
public final class Iso8601DateTime
implements ValueObject,
Comparable<Iso8601DateTime>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter JODA_FORMATTER = ISODateTimeFormat.dateTime();
    private static final java.time.format.DateTimeFormatter JAVA_FORMATTER = java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    @IsIso8601DateTime
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    private Iso8601DateTime(DateTime value) {
        this(JODA_FORMATTER.print(value));
    }

    private Iso8601DateTime(String value) {
        this.value = value;
    }

    private Iso8601DateTime(ZonedDateTime value) {
        this.value = value.format(JAVA_FORMATTER);
    }

    private Iso8601DateTime(LocalDateTime value) {
        this(value.atZone(ZoneId.systemDefault()));
    }

    protected Iso8601DateTime() {
        this.value = null;
    }

    public static Iso8601DateTime now() {
        return Iso8601DateTime.fromLocalDateTime(LocalDateTime.now());
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Iso8601DateTime other = (Iso8601DateTime)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    @Override
    public int compareTo(Iso8601DateTime o) {
        return this.value.compareTo(o.value);
    }

    public LocalDateTime getValueAsLocalDateTime() {
        ZonedDateTime valueAsZonedDateTime = this.getValueAsZonedDateTime();
        ZonedDateTime inLocalTimeZone = valueAsZonedDateTime.withZoneSameInstant(ZoneId.systemDefault());
        return inLocalTimeZone.toLocalDateTime();
    }

    public ZonedDateTime getValueAsZonedDateTime() {
        return ZonedDateTime.parse(this.value);
    }

    public static Iso8601DateTime fromString(String value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime.parse(value);
        return new Iso8601DateTime(value);
    }

    public static Iso8601DateTime fromDateTime(DateTime value) {
        if (value == null) {
            return null;
        }
        return new Iso8601DateTime(value);
    }

    public static Iso8601DateTime fromZonedDateTime(ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return new Iso8601DateTime(value);
    }

    public static Optional<DateTime> asDateTime(Iso8601DateTime value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value.getValueAsDateTime());
    }

    public DateTime getValueAsDateTime() {
        return DateTime.parse(this.value);
    }

    public static Iso8601DateTime fromLocalDateTime(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return new Iso8601DateTime(value);
    }

    public String format(java.time.format.DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            return null;
        }
        return this.getValueAsLocalDateTime().format(dateTimeFormatter);
    }
}

