/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="frivalue")
public class FRIValue
implements Comparable<FRIValue>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("FRI:(.*)/(\\w*)(?:[?]ctrlkey=([A-Z0-9]+))?", 2);
    @IsFinancialResourceIdentifier
    @XmlValue
    private final String fri;

    protected FRIValue() {
        this.fri = null;
    }

    private FRIValue(String fri) {
        this.fri = fri;
    }

    public static FRIValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new FRIValue(value);
    }

    public static FRIValue valueOf(String identifier, String type) {
        if (identifier == null || type == null) {
            return null;
        }
        return FRIValue.fromString("FRI:" + identifier + "/" + type);
    }

    public static FRIValue valueOf(String identifier, String type, String controlKey) {
        if (identifier == null || type == null) {
            return null;
        }
        if (controlKey == null) {
            return FRIValue.valueOf(identifier, type);
        }
        return FRIValue.fromString(String.format("FRI:%s/%s?ctrlkey=%s", identifier, type, controlKey));
    }

    @Override
    public String getValueAsString() {
        return this.fri;
    }

    public String getId() {
        return this.getGroup(PATTERN.matcher(this.fri == null ? "" : this.fri), 1);
    }

    public String getType() {
        return this.getGroup(PATTERN.matcher(this.fri == null ? "" : this.fri), 2);
    }

    public String getControlKey() {
        return this.getGroup(PATTERN.matcher(this.fri == null ? "" : this.fri), 3);
    }

    private String getGroup(Matcher matcher, int groupNumber) {
        if (matcher.find()) {
            return matcher.group(groupNumber);
        }
        return "";
    }

    public static Optional<String> asString(FRIValue friValue) {
        if (friValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(friValue.getValueAsString());
    }

    public String toString() {
        return this.fri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fri == null ? 0 : this.fri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FRIValue other = (FRIValue)obj;
        return !(this.fri == null ? other.fri != null : !this.fri.equals(other.fri));
    }

    @Override
    public int compareTo(FRIValue o) {
        return this.fri.compareTo(o.fri);
    }
}

