/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsDateTimeString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="localdatetimestring")
public class DateTimeStringValue
implements Comparable<DateTimeStringValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern(IsDateTimeString.DATE_TIME_FORMAT.ISO_EXTENDED.getFormat());
    @IsDateTimeString(format=IsDateTimeString.DATE_TIME_FORMAT.ISO_EXTENDED)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected DateTimeStringValue() {
        this.value = null;
    }

    private DateTimeStringValue(String value) {
        this.value = value;
    }

    private DateTimeStringValue(DateTime value) {
        this.value = FORMATTER.print(value);
    }

    public static DateTimeStringValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new DateTimeStringValue(value);
    }

    public static DateTimeStringValue fromDateTime(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTimeStringValue(value);
    }

    public String getValueAsString() {
        return this.value;
    }

    public DateTime getValueAsDateTime() {
        return FORMATTER.parseDateTime(this.value);
    }

    public static Optional<String> asString(DateTimeStringValue dateTimeString) {
        if (dateTimeString == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(dateTimeString.getValueAsString());
    }

    public static Optional<DateTime> asDateTime(DateTimeStringValue dateTimeString) {
        if (dateTimeString == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(dateTimeString.getValueAsDateTime());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeStringValue other = (DateTimeStringValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(DateTimeStringValue o) {
        return this.value.compareTo(o.value);
    }
}

