/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.IsEmail;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsLanguage;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import iso.std.iso._20022.tech.xsd.GenderCode;
import iso.std.iso._20022.tech.xsd.PersonIdentificationType1Code;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="cashuserinformation", propOrder={"msisdn", "identificationType", "identificationNumber", "firstName", "surName", "languageCode", "dateOfBirth", "identity", "email", "gender"})
public class CashUserInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Length(max=16)
    @IsMSISDN
    @XmlElement(name="msisdn", required=false)
    private String msisdn;
    @XmlElement(name="identificationtype", type=PersonIdentificationType1Code.class, required=true)
    @NotNull
    private PersonIdentificationType1Code identificationType;
    @NotBlank
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="identificationnumber", required=true)
    private String identificationNumber;
    @IsFirstname
    @XmlElement(name="firstname", required=false)
    private String firstName;
    @IsSurname
    @XmlElement(name="surname", required=false)
    private String surName;
    @IsLanguage
    @XmlElement(name="languagecode")
    private String languageCode;
    @IsDateString(format=IsDateString.DATE_FORMAT.ISO, minDate="1890-01-01")
    @XmlElement(name="dateofbirth", required=false)
    private String dateOfBirth;
    @NotNull
    @IsIdentity
    @XmlElement(name="identity", required=true)
    private String identity;
    @IsEmail
    @XmlElement(name="email", required=false)
    private String email;
    @XmlElement(name="gender")
    private GenderCode gender;

    public String getIdentity() {
        return this.identity;
    }

    public DateTime getDateOfBirth() {
        return this.dateOfBirth != null ? DateTime.parse(this.dateOfBirth) : null;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public PersonIdentificationType1Code getIdentificationType() {
        return this.identificationType;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getSurName() {
        return this.surName;
    }

    public GenderCode getGender() {
        return this.gender;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setDateOfBirth(DateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth != null ? dateOfBirth.toString("yyyy-MM-dd") : null;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public void setIdentificationType(PersonIdentificationType1Code identificationType) {
        this.identificationType = identificationType;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setSurName(String surName) {
        this.surName = surName;
    }

    public void setGender(GenderCode gender) {
        this.gender = gender;
    }
}

