/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.transientfinancialresource.v1_0.createtransientfinancialresource;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.transientfinancialresource.v1_0.common.ResourceAdditionalInformation;
import com.ericsson.em.m3if.transientfinancialresource.v1_0.common.ResourceType;
import com.ericsson.em.m3if.transientfinancialresource.v1_0.common.ResourceUsageOccurrenceValue;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.Duration;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_1.common.UrlValue;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/transientfinancialresource/v1_0", name="createtransientfinancialresourcerequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/transientfinancialresource/v1_0", name="", propOrder={"referenceId", "sponsorFri", "intendedConsumer", "amount", "resourceType", "usageOccurrence", "validityTime", "additionalInformation", "callbackUrl", "quoteId"})
public class CreateTransientFinancialResourceRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="referenceid", type=ClientReferenceIdValue.class, required=true)
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="sponsorfri", type=FRIValue.class)
    private FRIValue sponsorFri;
    @Valid
    @NotNull
    @XmlElement(name="intendedconsumer", type=IdentityValue.class, required=true)
    private IdentityValue intendedConsumer;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="resourcetype", type=ResourceType.class, required=true)
    private ResourceType resourceType;
    @Valid
    @NotNull
    @XmlElement(name="usageoccurrence", type=ResourceUsageOccurrenceValue.class, required=true)
    private ResourceUsageOccurrenceValue usageOccurrence;
    @Valid
    @NotNull
    @XmlElement(name="validitytime", type=Duration.class, required=true)
    private Duration validityTime;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="additionalinformationlist")
    @XmlElements(value={@XmlElement(name="additionalinformation", type=ResourceAdditionalInformation.class)})
    private List<ResourceAdditionalInformation> additionalInformation;
    @Valid
    @XmlElement(name="callbackurl", type=UrlValue.class)
    private UrlValue callbackUrl;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;

    public ClientReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ClientReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }

    public Optional<FRIValue> getSponsorFri() {
        return Optional.ofNullable(this.sponsorFri);
    }

    public void setSponsorFri(FRIValue sponsorFri) {
        this.sponsorFri = sponsorFri;
    }

    public IdentityValue getIntendedConsumer() {
        return this.intendedConsumer;
    }

    public void setIntendedConsumer(IdentityValue intendedConsumer) {
        this.intendedConsumer = intendedConsumer;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceUsageOccurrenceValue getUsageOccurrence() {
        return this.usageOccurrence;
    }

    public void setUsageOccurrence(ResourceUsageOccurrenceValue usage) {
        this.usageOccurrence = usage;
    }

    public Duration getValidityTime() {
        return this.validityTime;
    }

    public void setValidityTime(Duration validityTime) {
        this.validityTime = validityTime;
    }

    public List<ResourceAdditionalInformation> getAdditionalInformation() {
        return Optional.ofNullable(this.additionalInformation).orElse(Collections.emptyList());
    }

    public void setAdditionalInformation(List<ResourceAdditionalInformation> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public Optional<UrlValue> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public void setCallbackUrl(UrlValue callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

