/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v2_0.depositinstruction;

import com.ericsson.em.m3if.operations.annotations.IdentityTraceAction;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAsynchronousHint;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.any.depositinstruction.IDepositInstructionRequest;
import com.ericsson.em.m3if.settlement.any.depositinstruction.IDepositInstructionResponse;
import com.ericsson.em.m3if.settlement.v2_0.depositinstruction.DepositInstructionResponse;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIntegerStringWithinRange;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@IdentityTraceAsynchronousHint(action=IdentityTraceAction.REGISTER, field="depositInstructionId", grouping="depositinstruction")
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="depositinstructionrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="", propOrder={"transactionTimeStamp", "amount", "depositInstructionId", "senderBankCode", "senderAccountNumber", "senderFirstname", "senderSurname", "message", "senderMsisdn", "transmissionCounter", "transactionId"})
@SignedElements(value={"amount/amount", "amount/currency", "depositinstructionid", "senderbankcode", "senderaccountnumber"})
public class DepositInstructionRequest
implements IDepositInstructionRequest {
    @Valid
    @IsDateTimeValue
    @NotNull
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="depositinstructionid", required=true)
    private String depositInstructionId;
    @IsBankCode
    @XmlElement(name="senderbankcode", required=false)
    private String senderBankCode;
    @NotNull
    @IsBankAccount
    @XmlElement(name="senderaccountnumber", required=true)
    private String senderAccountNumber;
    @IsFirstname
    @XmlElement(name="senderfirstname", required=false)
    private String senderFirstname;
    @IsSurname
    @XmlElement(name="sendersurname", required=false)
    private String senderSurname;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="message", required=false)
    private String message;
    @IsMSISDN
    @XmlElement(name="sendermsisdn", required=false)
    private String senderMsisdn;
    @NotBlank
    @IsIntegerStringWithinRange(min=0)
    @XmlElement(name="transmissioncounter", required=true)
    private String transmissionCounter;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="transactionid", required=true)
    private String transactionId;

    @Override
    public String getTransmissionCounter() {
        return this.transmissionCounter;
    }

    @Override
    public void setTransmissionCounter(String transmissionCounter) {
        this.transmissionCounter = transmissionCounter;
    }

    @Override
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    @Override
    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public String getDepositInstructionId() {
        return this.depositInstructionId;
    }

    @Override
    public void setDepositInstructionId(String depositInstructionId) {
        this.depositInstructionId = depositInstructionId;
    }

    @Override
    public String getSenderBankCode() {
        return this.senderBankCode;
    }

    @Override
    public void setSenderBankCode(String senderBankCode) {
        this.senderBankCode = senderBankCode;
    }

    @Override
    public String getSenderAccountNumber() {
        return this.senderAccountNumber;
    }

    @Override
    public void setSenderAccountNumber(String senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
    }

    @Override
    public String getSenderFirstname() {
        return this.senderFirstname;
    }

    @Override
    public void setSenderFirstname(String senderFirstname) {
        this.senderFirstname = senderFirstname;
    }

    @Override
    public String getSenderSurname() {
        return this.senderSurname;
    }

    @Override
    public void setSenderSurname(String senderSurname) {
        this.senderSurname = senderSurname;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getSenderMsisdn() {
        return this.senderMsisdn;
    }

    @Override
    public void setSenderMsisdn(String senderMsisdn) {
        this.senderMsisdn = senderMsisdn;
    }

    @Override
    public Class<? extends IDepositInstructionRequest> requestClass() {
        return DepositInstructionRequest.class;
    }

    @Override
    public Class<? extends IDepositInstructionResponse> responseClass() {
        return DepositInstructionResponse.class;
    }

    @Override
    public String getBankInstructionId() {
        return this.getDepositInstructionId();
    }

    @Override
    public void setBankInstructionId(String instructionId) {
        this.setDepositInstructionId(instructionId);
    }

    @Override
    public String getBankCode() {
        return this.getSenderBankCode();
    }

    @Override
    public void setBankCode(String bankCode) {
        this.setSenderBankCode(bankCode);
    }

    @Override
    public String getAccountNumber() {
        return this.getSenderBankCode();
    }

    @Override
    public void setAccountNumber(String accountNumber) {
        this.setSenderAccountNumber(accountNumber);
    }

    @Override
    public String getFirstname() {
        return this.getSenderFirstname();
    }

    @Override
    public void setFirstname(String firstname) {
        this.setSenderFirstname(firstname);
    }

    @Override
    public String getSurname() {
        return this.getSenderSurname();
    }

    @Override
    public void setSurname(String surname) {
        this.setSenderSurname(surname);
    }

    @Override
    public String getMsisdn() {
        return this.getSenderMsisdn();
    }

    @Override
    public void setMsisdn(String msisdn) {
        this.setSenderMsisdn(msisdn);
    }
}

