/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.savings.v1_0.common;

import com.ericsson.em.m3if.savings.v1_0.common.InterestCalculationPeriod;
import com.ericsson.em.m3if.savings.v1_0.common.InterestPayoutPeriod;
import com.ericsson.em.m3if.savings.v1_0.common.InterestType;
import com.ericsson.em.m3if.savings.v1_0.common.PolicyForInterestCalculation;
import com.ericsson.em.m3if.savings.v1_0.common.PostTermExpiryAction;
import com.ericsson.em.m3if.savings.v1_0.common.SavingsProductState;
import com.ericsson.em.m3if.savings.v1_0.common.TermUnit;
import com.ericsson.em.validators.IsASCIISimpleString;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsPercentage;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/savings/v1_0/common", name="savingsproduct", propOrder={"productCode", "productName", "productDescription", "activationDate", "expiryDate", "depositlLock", "withdrawalLock", "term", "termUnit", "postTermExpiryAction", "policyForInterestCalculation", "minimumBalance", "interestType", "interestRate", "interestAmount", "interestCalculationPeriod", "interestPayoutPeriod", "savingsProductState"})
public class SavingsProduct
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Length(max=32)
    @NotNull
    @NotBlank
    @IsRestrictedString
    @XmlElement(name="productcode", required=true)
    private String productCode;
    @Length(max=64)
    @IsRestrictedString
    @XmlElement(name="productname")
    private String productName;
    @Length(max=128)
    @IsASCIISimpleString
    @XmlElement(name="productdescription")
    private String productDescription;
    @NotNull
    @XmlSchemaType(name="date")
    @XmlElement(name="activationdate", required=true)
    private XMLGregorianCalendar activationDate;
    @XmlSchemaType(name="date")
    @XmlElement(name="expirydate")
    private XMLGregorianCalendar expiryDate;
    @XmlElement(name="depositlock", defaultValue="false")
    private boolean depositlLock = false;
    @XmlElement(name="withdrawallock", defaultValue="false")
    private boolean withdrawalLock = false;
    @Min(value=1L)
    @XmlElement(name="term")
    private @Min(value=1L) Integer term;
    @Valid
    @XmlElement(name="termunit", type=TermUnit.class)
    private TermUnit termUnit;
    @Valid
    @XmlElement(name="posttermexpiryaction", type=PostTermExpiryAction.class)
    private PostTermExpiryAction postTermExpiryAction;
    @Valid
    @XmlElement(name="policyforinterestcalculation", type=PolicyForInterestCalculation.class)
    private PolicyForInterestCalculation policyForInterestCalculation;
    @IsAmount
    @XmlElement(name="minimumbalance")
    private BigDecimal minimumBalance;
    @NotNull
    @Valid
    @XmlElement(name="interesttype", type=InterestType.class, required=true)
    private InterestType interestType;
    @IsPercentage(maxValue=100)
    @XmlElement(name="interestrate")
    private BigDecimal interestRate;
    @IsAmount
    @XmlElement(name="interestamount")
    private BigDecimal interestAmount;
    @NotNull
    @Valid
    @XmlElement(name="interestcalculationperiod", type=InterestCalculationPeriod.class, required=true)
    private InterestCalculationPeriod interestCalculationPeriod;
    @NotNull
    @Valid
    @XmlElement(name="interestpayoutperiod", type=InterestPayoutPeriod.class, required=true)
    private InterestPayoutPeriod interestPayoutPeriod;
    @Valid
    @XmlElement(name="state", type=SavingsProductState.class)
    private SavingsProductState savingsProductState;

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public XMLGregorianCalendar getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(XMLGregorianCalendar activationDate) {
        this.activationDate = activationDate;
    }

    public XMLGregorianCalendar getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(XMLGregorianCalendar expiryDate) {
        this.expiryDate = expiryDate;
    }

    public boolean isDepositlLock() {
        return this.depositlLock;
    }

    public void setDepositlLock(boolean depositlLock) {
        this.depositlLock = depositlLock;
    }

    public boolean isWithdrawalLock() {
        return this.withdrawalLock;
    }

    public void setWithdrawalLock(boolean withdrawalLock) {
        this.withdrawalLock = withdrawalLock;
    }

    public Integer getTerm() {
        return this.term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public TermUnit getTermUnit() {
        return this.termUnit;
    }

    public void setTermUnit(TermUnit termUnit) {
        this.termUnit = termUnit;
    }

    public PostTermExpiryAction getPostTermExpiryAction() {
        return this.postTermExpiryAction;
    }

    public void setPostTermExpiryAction(PostTermExpiryAction postTermExpiryAction) {
        this.postTermExpiryAction = postTermExpiryAction;
    }

    public PolicyForInterestCalculation getPolicyForInterestCalculation() {
        return this.policyForInterestCalculation;
    }

    public void setPolicyForInterestCalculation(PolicyForInterestCalculation policyForInterestCalculation) {
        this.policyForInterestCalculation = policyForInterestCalculation;
    }

    public BigDecimal getMinimumBalance() {
        return this.minimumBalance;
    }

    public void setMinimumBalance(BigDecimal minimumBalance) {
        this.minimumBalance = minimumBalance;
    }

    public InterestType getInterestType() {
        return this.interestType;
    }

    public void setInterestType(InterestType interestType) {
        this.interestType = interestType;
    }

    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }

    public BigDecimal getInterestAmount() {
        return this.interestAmount;
    }

    public void setInterestAmount(BigDecimal interestAmount) {
        this.interestAmount = interestAmount;
    }

    public InterestCalculationPeriod getInterestCalculationPeriod() {
        return this.interestCalculationPeriod;
    }

    public void setInterestCalculationPeriod(InterestCalculationPeriod interestCalculationPeriod) {
        this.interestCalculationPeriod = interestCalculationPeriod;
    }

    public InterestPayoutPeriod getInterestPayoutPeriod() {
        return this.interestPayoutPeriod;
    }

    public void setInterestPayoutPeriod(InterestPayoutPeriod interestPayoutPeriod) {
        this.interestPayoutPeriod = interestPayoutPeriod;
    }

    public SavingsProductState getSavingsProductState() {
        return this.savingsProductState;
    }

    public void setSavingsProductState(SavingsProductState savingsProductState) {
        this.savingsProductState = savingsProductState;
    }
}

