/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.updateaccountholdercontactinformation;

import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.CommunicationAddress3;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="updateaccountholdercontactinformationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "contactInformations", "reason"})
public class UpdateAccountHolderContactInformationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="identity")
    @IsIdentity
    private String identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="contactinformations")
    @XmlElements(value={@XmlElement(name="contactinformation", type=CommunicationAddress3.class)})
    private List<CommunicationAddress3> contactInformations;
    @Length(max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;

    public UpdateAccountHolderContactInformationRequest() {
    }

    public UpdateAccountHolderContactInformationRequest(String identity) {
        this.identity = identity;
    }

    public UpdateAccountHolderContactInformationRequest(String identity, List<CommunicationAddress3> contactInformations) {
        this.identity = identity;
        this.contactInformations = contactInformations;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public List<CommunicationAddress3> getContactInformations() {
        if (this.contactInformations == null) {
            return Collections.emptyList();
        }
        return this.contactInformations;
    }

    public void setContactInformations(List<CommunicationAddress3> contactInformations) {
        this.contactInformations = contactInformations;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public CommunicationAddress3 getPrimary() {
        if (this.hasPrimary()) {
            return this.contactInformations.get(0);
        }
        return null;
    }

    public boolean hasPrimary() {
        return this.contactInformations != null && !this.contactInformations.isEmpty();
    }

    public CommunicationAddress3 getSecondary() {
        if (this.hasSecondary()) {
            return this.contactInformations.get(1);
        }
        return null;
    }

    public boolean hasSecondary() {
        return this.contactInformations != null && this.contactInformations.size() > 1;
    }
}

