/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.cashvoucher.v1_0.common;

import com.ericsson.em.m3if.cashvoucher.v1_0.common.CashVoucherStatus;
import com.ericsson.em.m3if.cashvoucher.v1_0.common.CashVoucherUser;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.annotations.SensitiveValue;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSecretString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/cashvoucher/v1_0/common", name="cashvoucherdatatype", propOrder={"token", "money", "sourceFri", "cashVoucherCreator", "cashVoucherCreatorName", "cashVoucherCancelledBy", "cashVoucherCancelledByName", "cashVoucherRedeemedBy", "cashVoucherRedeemedByName", "status", "sender", "receiver", "creationDateTime", "expireDateTime", "cancelledBy", "redeemedBy", "message", "finalizedDateTime", "destinationAccountFri", "updatedByIdentity", "incorrectSecretAttempts"})
public class CashVoucherDetails
implements Serializable {
    private static final long serialVersionUID = -7610939827738100273L;
    @IsSecretString
    @SensitiveValue
    @XmlElement(name="token")
    private String token;
    @XmlElement(name="money", type=MoneyDetails.class)
    @Valid
    @IsPositiveAmount
    private MoneyDetails money;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sourcefri")
    private String sourceFri;
    @IsIdentity
    @XmlElement(name="cashvouchercreator")
    private String cashVoucherCreator;
    @IsRestrictedString
    @XmlElement(name="cashvouchercreatorname")
    private String cashVoucherCreatorName;
    @IsIdentity
    @XmlElement(name="cashvouchercancelledby")
    private String cashVoucherCancelledBy;
    @IsRestrictedString
    @XmlElement(name="cashvouchercancelledbyname")
    private String cashVoucherCancelledByName;
    @IsIdentity
    @XmlElement(name="cashvoucherredeemedby")
    private String cashVoucherRedeemedBy;
    @IsRestrictedString
    @XmlElement(name="cashvoucherredeemedbyname")
    private String cashVoucherRedeemedByName;
    @Valid
    @XmlElement(name="status", type=CashVoucherStatus.class)
    private CashVoucherStatus status;
    @Valid
    @NotNull
    @XmlElement(name="sender", required=true, type=CashVoucherUser.class)
    private CashVoucherUser sender;
    @Valid
    @NotNull
    @XmlElement(name="receiver", required=true, type=CashVoucherUser.class)
    private CashVoucherUser receiver;
    @NotNull
    @XmlElement(name="creationdatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date creationDateTime;
    @XmlElement(name="expiredatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date expireDateTime;
    @Valid
    @XmlElement(name="cancelledby", required=false, type=CashVoucherUser.class)
    private CashVoucherUser cancelledBy;
    @Valid
    @XmlElement(name="redeemedby", required=false, type=CashVoucherUser.class)
    private CashVoucherUser redeemedBy;
    @IsMultilineRestrictedString
    @Length(max=128)
    @XmlElement(name="message")
    private String message;
    @XmlElement(name="finalizeddatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date finalizedDateTime;
    @IsFinancialResourceIdentifier
    @XmlElement(name="destinationaccountfri")
    private String destinationAccountFri;
    @IsIdentity
    @XmlElement(name="updatedbyidentity")
    private String updatedByIdentity;
    @XmlElement(name="incorrectsecretattempts")
    private int incorrectSecretAttempts;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public MoneyDetails getMoney() {
        return this.money;
    }

    public void setMoney(MoneyDetails money) {
        this.money = money;
    }

    public String getSourceFri() {
        return this.sourceFri;
    }

    public void setSourceFri(String sourceFri) {
        this.sourceFri = sourceFri;
    }

    public CashVoucherStatus getStatus() {
        return this.status;
    }

    public void setStatus(CashVoucherStatus status) {
        this.status = status;
    }

    public CashVoucherUser getSender() {
        return this.sender;
    }

    public void setSender(CashVoucherUser sender) {
        this.sender = sender;
    }

    public CashVoucherUser getReceiver() {
        return this.receiver;
    }

    public void setReceiver(CashVoucherUser receiver) {
        this.receiver = receiver;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DateTime getCreationDateTime() {
        return DateHelper.fromDate(this.creationDateTime);
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = DateHelper.toDate(creationDateTime);
    }

    public DateTime getExpireDateTime() {
        return DateHelper.fromDate(this.expireDateTime);
    }

    public void setExpireDateTime(DateTime expireDateTime) {
        this.expireDateTime = DateHelper.toDate(expireDateTime);
    }

    public String getCashVoucherCreator() {
        return this.cashVoucherCreator;
    }

    public void setCashVoucherCreator(String cashVoucherCreator) {
        this.cashVoucherCreator = cashVoucherCreator;
    }

    public String getCashVoucherCreatorName() {
        return this.cashVoucherCreatorName;
    }

    public void setCashVoucherCreatorName(String cashVoucherCreatorName) {
        this.cashVoucherCreatorName = cashVoucherCreatorName;
    }

    public String getCashVoucherCancelledBy() {
        return this.cashVoucherCancelledBy;
    }

    public void setCashVoucherCancelledBy(String cashVoucherCancelledBy) {
        this.cashVoucherCancelledBy = cashVoucherCancelledBy;
    }

    public String getCashVoucherCancelledByName() {
        return this.cashVoucherCancelledByName;
    }

    public void setCashVoucherCancelledByName(String cashVoucherCancelledByName) {
        this.cashVoucherCancelledByName = cashVoucherCancelledByName;
    }

    public String getCashVoucherRedeemedBy() {
        return this.cashVoucherRedeemedBy;
    }

    public void setCashVoucherRedeemedBy(String cashVoucherRedeemedBy) {
        this.cashVoucherRedeemedBy = cashVoucherRedeemedBy;
    }

    public String getCashVoucherRedeemedByName() {
        return this.cashVoucherRedeemedByName;
    }

    public void setCashVoucherRedeemedByName(String cashVoucherRedeemedByName) {
        this.cashVoucherRedeemedByName = cashVoucherRedeemedByName;
    }

    public CashVoucherUser getCancelledBy() {
        return this.cancelledBy;
    }

    public void setCancelledBy(CashVoucherUser cancelledBy) {
        this.cancelledBy = cancelledBy;
    }

    public CashVoucherUser getRedeemedBy() {
        return this.redeemedBy;
    }

    public void setRedeemedBy(CashVoucherUser redeemedBy) {
        this.redeemedBy = redeemedBy;
    }

    public DateTime getFinalizedDateTime() {
        return DateHelper.fromDate(this.finalizedDateTime);
    }

    public void setFinalizedDateTime(DateTime finalizedDateTime) {
        this.finalizedDateTime = DateHelper.toDate(finalizedDateTime);
    }

    public String getDestinationAccountFri() {
        return this.destinationAccountFri;
    }

    public void setDestinationAccountFri(String destinationAccountFri) {
        this.destinationAccountFri = destinationAccountFri;
    }

    public String getUpdatedByIdentity() {
        return this.updatedByIdentity;
    }

    public void setUpdatedByIdentity(String updatedByIdentity) {
        this.updatedByIdentity = updatedByIdentity;
    }

    public int getIncorrectSecretAttempts() {
        return this.incorrectSecretAttempts;
    }

    public void setIncorrectSecretAttempts(int incorrectSecretAttempts) {
        this.incorrectSecretAttempts = incorrectSecretAttempts;
    }
}

