/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom.view;

import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModel;
import com.ericsson.em.emm.ere.rma.custom.view.AbstractCollectionOfMultiFieldEntryVariable;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class CollectionOfMultiFieldEntriesVariable
extends AbstractCollectionOfMultiFieldEntryVariable
implements Observer {
    private String selectedEntry = "";

    public CollectionOfMultiFieldEntriesVariable(String label, CollectionOfMultiFieldsModel model) {
        super(label, model);
        this.model.addObserver(this);
    }

    @Override
    public Object getValueObject() {
        return this.model;
    }

    @Override
    public CollectionOfMultiFieldsModel getModel() {
        return this.model;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new CollectionOfMultiFieldEntriesPanel(this, this.model);
    }

    private void dataChanged(String selectedEntry) {
        this.selectedEntry = selectedEntry;
        this.fireValueChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
        assert (this.model == o);
        if (o instanceof CollectionOfMultiFieldsModel) {
            CollectionOfMultiFieldsModel.ModelStatus status;
            CollectionOfMultiFieldsModel currModel = (CollectionOfMultiFieldsModel)o;
            if (arg instanceof CollectionOfMultiFieldsModel.ModelStatus && ((status = (CollectionOfMultiFieldsModel.ModelStatus)((Object)arg)).equals((Object)CollectionOfMultiFieldsModel.ModelStatus.NEW_ENTRY_ADDED) || status.equals((Object)CollectionOfMultiFieldsModel.ModelStatus.ENTRY_DELETED) || status.equals((Object)CollectionOfMultiFieldsModel.ModelStatus.ENTRY_NAME_UPDATED))) {
                CollectionOfMultiFieldEntriesPanel panel = (CollectionOfMultiFieldEntriesPanel)this.getPanelVariableEditor();
                panel.updatePanel(currModel);
            }
        }
    }

    public String getSelectedEntry() {
        return this.selectedEntry;
    }

    private static class CollectionOfMultiFieldEntriesPanel
    extends AbstractPanelVariableEditor
    implements PanelVariableEditor,
    ActionListener {
        private final transient CollectionOfMultiFieldEntriesVariable variable;
        private final JComboBox<String> comboBox;

        CollectionOfMultiFieldEntriesPanel(CollectionOfMultiFieldEntriesVariable variable, CollectionOfMultiFieldsModel model) {
            super(new BorderLayout());
            this.variable = variable;
            this.comboBox = this.setupPanel();
            this.updatePanel(model);
        }

        private JComboBox<String> setupPanel() {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.setName("CollectionOfMultiFieldEntriesPanel.JComboBox.EntriesList");
            comboBox.setMaximumRowCount(10);
            comboBox.addActionListener(this);
            this.add(comboBox);
            return comboBox;
        }

        @Override
        public boolean isEditorValueValid() {
            return false;
        }

        @Override
        public Object getEditorValue() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String itemSelected = (String)this.comboBox.getSelectedItem();
            this.variable.dataChanged(itemSelected);
        }

        void updatePanel(CollectionOfMultiFieldsModel model) {
            String[] items = model.getEntryNames().toArray(new String[model.getEntryNames().size()]);
            String selectedItem = model.getCurrentEntryName();
            this.comboBox.setModel(new DefaultComboBoxModel<String>(items));
            this.comboBox.setSelectedItem(selectedItem);
        }
    }
}

