/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.em.emm.ere.rma.connector.EreNameDocument;
import com.ericsson.ere.gui.editors.interfaces.NewProxyEditorInterface;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EreNewRatingPeriodProxyEditor
implements NewProxyEditorInterface {
    RatingPeriodProxy myNewRatingPeriodProxy;
    private boolean successfulEdit = true;

    @Override
    public void performNew(final AbstractEreProxy abstractProxy) {
        final RatingManagerProxy ratingManagerProxy = abstractProxy.getRatingManagerProxy();
        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
        if (serviceListProxy.getServiceList() == null || serviceListProxy.getServiceList().isEmpty()) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "No Service in Service list", "There is no service defined in the Service list. \nPlease, add a Service before continuing.");
            return;
        }
        ArrayList<String> serviceNameList = new ArrayList<String>(serviceListProxy.getServiceList().size());
        for (ServiceProxy serviceProxy : serviceListProxy.getServiceList()) {
            serviceNameList.add(serviceProxy.getName());
        }
        Collections.sort(serviceNameList);
        StringVariable serviceProviderVariable = new StringVariable("Service provider", "", new EreNameDocument());
        BaseVariable serviceVariable = new DropDownVariable("Service", 0, serviceNameList.toArray());
        StringVariable ratingPlanVariable = new StringVariable("Ratingplan", "", new EreNameDocument());
        StringVariable nameVariable = new StringVariable("Name", "", new EreNameDocument());
        DateAndTimeVariable startDateVariable = new DateAndTimeVariable("Start date", DateAndTimeVariable.Content.DATE_TIME, "99990101T000000000");
        if (!(abstractProxy instanceof ServiceProviderListProxy)) {
            if (abstractProxy instanceof ServiceProviderProxy) {
                ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)abstractProxy;
                serviceProviderVariable.setValue(serviceProviderProxy.getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", serviceProviderProxy.getName());
                ((Variable)serviceVariable).setAllowEdit(false);
            } else if (abstractProxy instanceof RatingPlanProxy) {
                ratingPlanProxy = (RatingPlanProxy)abstractProxy;
                serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                ((Variable)serviceVariable).setAllowEdit(false);
                ratingPlanVariable.setValue(ratingPlanProxy.getName());
                ratingPlanVariable.setAllowEdit(false);
            } else if (abstractProxy instanceof SavedListProxy) {
                SavedListProxy savedListProxy = (SavedListProxy)abstractProxy;
                serviceProviderVariable.setValue(savedListProxy.getServiceProviderProxy().getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", savedListProxy.getServiceName());
                ((Variable)serviceVariable).setAllowEdit(false);
                ratingPlanVariable.setValue(savedListProxy.getRatingPlanName());
                ratingPlanVariable.setAllowEdit(false);
            } else if (abstractProxy instanceof RatingPeriodProxy) {
                ratingPlanProxy = ((RatingPeriodProxy)abstractProxy).getParentRatingPlanProxy();
                serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                ((Variable)serviceVariable).setAllowEdit(false);
                ratingPlanVariable.setValue(ratingPlanProxy.getName());
                ratingPlanVariable.setAllowEdit(false);
            }
        }
        VarTableModel newSettings = new VarTableModel();
        newSettings.addRow(serviceProviderVariable);
        newSettings.addRow(serviceVariable);
        newSettings.addRow(ratingPlanVariable);
        newSettings.addRow(nameVariable);
        newSettings.addRow(startDateVariable);
        PropertiesEditor.showDialogEdit(newSettings, "New rating period", new EditablePropertiesInterface(){

            @Override
            public void cancel() {
            }

            @Override
            public String getTitle() {
                return null;
            }

            @Override
            public void update(VarTableModel model) throws PropertiesException {
                block14: {
                    EreNewRatingPeriodProxyEditor.this.successfulEdit = true;
                    SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        Variable var = (Variable)model.getValueAt(i, 1);
                        if (var.isValueValid() && !var.getValueString().trim().isEmpty()) continue;
                        EreNewRatingPeriodProxyEditor.this.showErrorDialog(var);
                        return;
                    }
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                        throw new PropertiesException("The rating period name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Ratingplan"))) {
                        throw new PropertiesException("The rating plan name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Service provider"))) {
                        throw new PropertiesException("The service provider name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    if (EreNewRatingPeriodProxyEditor.this.successfulEdit) {
                        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
                        ServiceProviderListProxy serviceProviderListProxy = ratingManagerProxy.getServiceProviderListProxy();
                        ServiceProxy serviceProxy = serviceListProxy.getServiceProxy(newSettings.getParameterAsString("Service"));
                        EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = null;
                        try {
                            RatingPlanProxy ratingPlanProxy;
                            ServiceProviderProxy serviceProviderProxy;
                            String ratingPlanName = newSettings.getParameterAsString("Ratingplan");
                            String serviceProviderName = newSettings.getParameterAsString("Service provider");
                            Element defaultXML = RatingPeriodProxy.createNewRatingPeriodXML(serviceProxy.instantiateServiceObject(), newSettings.getParameterAsString("Name"), ratingPlanName, serviceProviderName);
                            if (abstractProxy instanceof RatingPeriodProxy) {
                                RatingPlanProxy ratingPlanProxy2 = ((RatingPeriodProxy)abstractProxy).getParentRatingPlanProxy();
                                EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPlanProxy2.createRatingPeriod(newSettings, defaultXML);
                                break block14;
                            }
                            if (abstractProxy instanceof RatingPlanProxy) {
                                RatingPlanProxy ratingPlanProxy3 = (RatingPlanProxy)abstractProxy;
                                EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPlanProxy3.createRatingPeriod(newSettings, defaultXML);
                                break block14;
                            }
                            if (abstractProxy instanceof SavedListProxy) {
                                SavedListProxy savedListProxy = (SavedListProxy)abstractProxy;
                                EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = savedListProxy.getRatingPlanProxy().createRatingPeriod(newSettings, defaultXML);
                                break block14;
                            }
                            if (abstractProxy instanceof ServiceProviderProxy) {
                                ServiceProviderProxy serviceProviderProxy2 = (ServiceProviderProxy)abstractProxy;
                                Document document = XMLUtil.createEmptyDocument();
                                Element planElement = document.createElement("RatingPlan");
                                planElement.setAttribute("Name", newSettings.getParameterAsString("Ratingplan"));
                                planElement.setAttribute("Service", newSettings.getParameterAsString("Service"));
                                Element periodElement = document.createElement("RatingPeriod");
                                periodElement.setAttribute("Name", newSettings.getParameterAsString("Name"));
                                periodElement.setAttribute("RatingStructureFile", "");
                                periodElement.setAttribute("StartDate", newSettings.getParameterAsString("Start date"));
                                Node cloneNode = defaultXML.cloneNode(true);
                                document.adoptNode(cloneNode);
                                periodElement.appendChild(cloneNode);
                                planElement.appendChild(periodElement);
                                RatingPlanProxy ratingPlanProxy4 = serviceProviderProxy2.createRatingPlanAndPeriod(planElement);
                                EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPlanProxy4.getRatingPeriodProxy(newSettings.getParameterAsString("Name"), newSettings.getParameterAsString("Start date"));
                                break block14;
                            }
                            if (!(abstractProxy instanceof ServiceProviderListProxy)) break block14;
                            String sName = newSettings.getParameterAsString("Service");
                            String spName = newSettings.getParameterAsString("Service provider");
                            String rpName = newSettings.getParameterAsString("Ratingplan");
                            if (!serviceProviderListProxy.serviceProviderExists(spName)) {
                                SettingsMap serviceProviderSettings = new SettingsMap();
                                serviceProviderSettings.setParameter("Name", spName);
                                serviceProviderListProxy.createServiceProvider(serviceProviderSettings);
                            }
                            if (!(serviceProviderProxy = serviceProviderListProxy.getServiceProvider(spName)).ratingPlanExists(rpName)) {
                                SettingsMap ratingPlanSettings = new SettingsMap();
                                ratingPlanSettings.setParameter("Name", rpName);
                                ratingPlanSettings.setParameter("Service", sName);
                                serviceProviderProxy.createRatingPlan(ratingPlanSettings);
                            }
                            if (sName.equals((ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(rpName)).getServiceName())) {
                                EreNewRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
                                break block14;
                            }
                            throw new IllegalArgumentException("\nRating plan " + ratingPlanProxy.getName() + " does not belong to service " + sName + ".");
                        }
                        catch (Exception e) {
                            throw new PropertiesException("Could not create new rating period : " + e.getMessage(), e);
                        }
                    }
                }
            }

            @Override
            public boolean isSuccessful() {
                return EreNewRatingPeriodProxyEditor.this.successfulEdit;
            }
        });
    }

    @Override
    public AbstractEreProxy getCreatedProxy() {
        return this.myNewRatingPeriodProxy;
    }

    private void showErrorDialog(Variable var) {
        DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Invalid input", "The entered " + var.getLabel().toLowerCase() + " is invalid.");
        this.successfulEdit = false;
    }
}

