/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp.persistence;

import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.privacy.PersonalData;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.crypto.util.ByteArrays;
import com.ericsson.lwac.database.persistence.BaseEntity;
import org.joda.time.DateTime;

public class Otp
extends BaseEntity {
    private static final long serialVersionUID = 3493088303283760673L;
    private DateTime expiryDate;
    private String identification;
    private String operation;
    @PersonalData(type={PersonalData.PersonalDataType.PASSWORD})
    private byte[] otpHash;
    private byte[] salt;
    private int tries;
    private OtpOperations operationType;
    private String otpTarget;
    private String generatedBy;

    public DateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(DateTime date) {
        this.expiryDate = date;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification.toLowerCase();
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public byte[] getOtpHash() {
        return ByteArrays.safeCopy((byte[])this.otpHash);
    }

    public void setOtpHash(byte[] otpHash) {
        this.otpHash = ByteArrays.safeCopy((byte[])otpHash);
    }

    public byte[] getSalt() {
        return ByteArrays.safeCopy((byte[])this.salt);
    }

    public void setSalt(byte[] salt) {
        this.salt = ByteArrays.safeCopy((byte[])salt);
    }

    public int getTries() {
        return this.tries;
    }

    public void setTries(int tries) {
        this.tries = tries;
    }

    public OtpOperations getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OtpOperations operationType) {
        this.operationType = operationType;
    }

    public String getOtpTarget() {
        return this.otpTarget;
    }

    public void setOtpTarget(String otpTarget) {
        this.otpTarget = otpTarget;
    }

    public String getGeneratedBy() {
        return this.generatedBy;
    }

    public void setGeneratedBy(String generatedBy) {
        this.generatedBy = generatedBy;
    }

    protected void validate() {
        if (this.expiryDate == null) {
            throw new ValidationException("ExpiryDate is null in OTP");
        }
        if (this.identification == null) {
            throw new ValidationException("Identity is null in OTP");
        }
        if (this.otpHash == null) {
            throw new ValidationException("OtpHash is null in OTP");
        }
        if (this.salt == null) {
            throw new ValidationException("Salt is null in OTP");
        }
    }
}

