/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.otp.OtpLoginClusterProvider;
import com.ericsson.em.emc.otp.OtpLoginProvider;
import com.ericsson.em.emc.otp.OtpLoginSession;
import com.ericsson.em.emc.otp.OtpLoginSessionManager;
import com.ericsson.em.emc.otp.OtpLoginSessionRefreshMessage;
import com.ericsson.lwac.cluster.ClusterChannel;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.deployer.BeanId;
import com.google.common.base.Throwables;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.io.NotSerializableException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OtpLoginSessionManagerBean
implements OtpLoginSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(OtpLoginSessionManagerBean.class);
    @Resource
    private ClusterService clusterService;
    private final Map<BeanId, OtpLoginClusterProvider> otpProviders = new ConcurrentHashMap<BeanId, OtpLoginClusterProvider>();
    private final ReentrantLock registerLock = new ReentrantLock();

    @Override
    public void register(BeanId beanId) {
        if (this.otpProviders.containsKey(beanId)) {
            logger.debug("Cluster message listener for bean ID: {} already registered", (Object)beanId.getId());
        } else {
            try {
                if (!this.registerLock.tryLock(2L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Could not register '" + beanId.getId() + "' in time");
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while registering '" + beanId.getId(), e);
            }
            try {
                if (this.otpProviders.containsKey(beanId)) {
                    logger.debug("Cluster message listener for bean ID: {} already registered", (Object)beanId.getId());
                } else {
                    logger.debug("Register cluster message listener for bean ID: {}", (Object)beanId.getId());
                    OtpLoginProvider provider = OtpLoginProvider.create(beanId);
                    ClusterChannel clusterChannel = this.clusterService.registerMessageListener(beanId, provider);
                    this.otpProviders.put(beanId, new OtpLoginClusterProvider(provider, clusterChannel));
                }
            }
            catch (ClusterException e) {
                throw Throwables.propagate(e);
            }
            finally {
                this.registerLock.unlock();
            }
        }
    }

    @Override
    public Optional<OtpLoginSession> getOtpSession(BeanId beanId, String sessionToken) {
        OtpLoginClusterProvider otpClusterProvider = this.otpProviders.get(beanId);
        if (otpClusterProvider == null) {
            logger.warn("{} is trying to fetch a login OTP but has not registered itself for OTP services", (Object)beanId);
        } else if (sessionToken != null) {
            return otpClusterProvider.get(sessionToken);
        }
        return Optional.empty();
    }

    @Override
    public boolean otpSessionExists(BeanId beanId, String sessionToken) {
        return this.getOtpSession(beanId, sessionToken).isPresent();
    }

    @Override
    public void addOtpSession(BeanId beanId, String sessionId, String userId) {
        OtpLoginClusterProvider otpClusterProvider = this.otpProviders.get(beanId);
        if (otpClusterProvider != null && sessionId != null && userId != null && otpClusterProvider.add(sessionId, userId)) {
            OtpLoginSessionRefreshMessage message = new OtpLoginSessionRefreshMessage(sessionId, userId);
            logger.debug("Sending OtpLoginSessionRefreshMessage to add session ID and user ID '{}' to currentLoginSessions for bean ID '{}'.", (Object)userId, (Object)beanId.getId());
            try {
                this.clusterService.castMessage(otpClusterProvider.getChannel(), message, ClusterService.CastOption.ASYNC);
            }
            catch (ClusterException | NotSerializableException e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void removeOtpSession(BeanId beanId, String sessionId) {
        OtpLoginClusterProvider otpClusterProvider = this.otpProviders.get(beanId);
        if (otpClusterProvider != null && sessionId != null && otpClusterProvider.remove(sessionId)) {
            logger.debug("Sending OtpLoginSessionRefreshMessage to remove session ID from currentLoginSessions for bean ID '{}'.", (Object)beanId.getId());
            OtpLoginSessionRefreshMessage message = new OtpLoginSessionRefreshMessage(sessionId);
            try {
                this.clusterService.castMessage(otpClusterProvider.getChannel(), message, ClusterService.CastOption.ASYNC);
            }
            catch (ClusterException | NotSerializableException e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }
}

