/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationreceiver.persistence;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import com.ericsson.em.privacy.PersonalData;
import com.ericsson.em.validation.Validation;
import com.ericsson.lwac.database.persistence.BaseEntity;
import java.util.Optional;

public class NotificationReceiver
extends BaseEntity
implements NotificationIdentity {
    private static final long serialVersionUID = 1L;
    @PersonalData(type={PersonalData.PersonalDataType.ID_NUMBER_AND_TYPE})
    private final Long accountHolderId;
    @PersonalData(type={PersonalData.PersonalDataType.FIRST_NAME})
    private final String firstName;
    @PersonalData(type={PersonalData.PersonalDataType.LAST_NAME})
    private final String surname;
    @PersonalData(type={PersonalData.PersonalDataType.MOBILE_NUMBER})
    private final String msisdn;
    @PersonalData(type={PersonalData.PersonalDataType.EMAIL_ADDRESS})
    private final String emailId;
    @PersonalData(type={PersonalData.PersonalDataType.LANGUAGE_CODE})
    private final String languageCode;

    public Long getAccountHolderId() {
        return this.accountHolderId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasMsisdn() {
        return this.msisdn != null && !this.msisdn.isEmpty();
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public boolean hasEmail() {
        return this.emailId != null && !this.emailId.isEmpty();
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    NotificationReceiver(NotificationReceiverBuilder builder) {
        this.mId = builder.id;
        this.accountHolderId = builder.accountHolderId;
        this.firstName = builder.firstname;
        this.surname = builder.surname;
        this.msisdn = builder.msisdn;
        this.emailId = builder.emailId;
        this.languageCode = builder.languageCode;
    }

    @Override
    public Optional<String> getNotificationReceiverIdentity(NotificationChannelType channelType) {
        switch (channelType) {
            case SMS: {
                return Optional.ofNullable(this.msisdn);
            }
            case EMAIL: {
                return Optional.ofNullable(this.emailId);
            }
        }
        return Optional.empty();
    }

    public static NotificationReceiverBuilder newBuilder() {
        return new NotificationReceiverBuilder();
    }

    public String toString() {
        return "NotificationReceiver [accountHolderId = " + this.accountHolderId + ", firstname = " + this.firstName + ", surname = " + this.surname + ", msisdn = " + this.msisdn + ", emailId = " + this.emailId + ", languageCode = " + this.languageCode + "]";
    }

    public static final class NotificationReceiverBuilder {
        private Long id;
        private Long accountHolderId;
        private String firstname;
        private String surname;
        private String msisdn;
        private String emailId;
        private String languageCode;

        public NotificationReceiverBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public NotificationReceiverBuilder accountId(Long accountHolderId) {
            this.accountHolderId = accountHolderId;
            return this;
        }

        public NotificationReceiverBuilder firstname(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public NotificationReceiverBuilder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public NotificationReceiverBuilder msisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public NotificationReceiverBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public NotificationReceiverBuilder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public NotificationReceiver build() {
            return Validation.validate(new NotificationReceiver(this));
        }
    }
}

