/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.json;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class MoneyJsonAdaptor
implements JsonSerializer<Money>,
JsonDeserializer<Money> {
    private static final String AMOUNT = "amount";
    private static final String CURRENCY = "currency";

    @Override
    public JsonElement serialize(Money src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        String amount = src.toBigDecimal().stripTrailingZeros().toPlainString();
        String currencyCode = src.getCurrency().getCurrencyCode();
        JsonObject object = new JsonObject();
        object.add(AMOUNT, new JsonPrimitive(amount));
        object.add(CURRENCY, new JsonPrimitive(currencyCode));
        return object;
    }

    @Override
    public Money deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Unable to parse Money, JSON is not object");
        }
        JsonObject object = json.getAsJsonObject();
        Currency currency = Currency.getInstance(object.get(CURRENCY).getAsString());
        BigDecimal amount = object.get(AMOUNT).getAsBigDecimal();
        return Money.valueOf(amount, currency);
    }
}

