/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelation;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileListener;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterOverride;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationDAO;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheCleaner;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cache.CacheSwapResult;
import com.ericsson.lwac.cache.LockingType;
import com.ericsson.lwac.cache.SecondaryCache;
import com.ericsson.lwac.cluster.ClusterChannel;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.batch.BatchCallback;
import com.ericsson.lwac.database.batch.BatchConfiguration;
import com.ericsson.lwac.database.batch.BatchCreator;
import com.ericsson.lwac.database.batch.DataConsumer;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.OptionalDependency;
import com.ericsson.lwac.jobs.JobExecutorService;
import com.ericsson.lwac.jobs.JobRejectedException;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.ericsson.lwac.timer.TimerCondition;
import com.ericsson.lwac.timer.TimerListener;
import com.ericsson.lwac.timer.TimerRegistration;
import com.ericsson.lwac.timer.TimerService;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emcc.profile.S"})
public class ProfileDAOBean
extends CryptoExtendedBaseEntityDAOBean<Profile>
implements ProfileDAO,
TimerListener {
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "emcc.profile.S";
    private static final String TABLE_NAME = "hier$profile";
    private static final String TABLE_SEQUENCE_NAME = "hier$profile_seq";
    private static final Logger logger = LoggerFactory.getLogger(ProfileDAOBean.class);
    private final Set<Long> loading = new CopyOnWriteArraySet<Long>();
    @Resource
    private ApplicationContext applicationContext;
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @Resource
    private CacheService cacheService;
    @EJB
    private BatchCreator batchCreator;
    @Resource
    private TransactionManager transactionManager;
    @Resource
    private JobExecutorService jobExecutorService;
    @Resource
    private StatisticsService statisticsService;
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private ProfileCounterRelationDAO profileCounterRelationDAO;
    @EJB
    private ThresholdConfigurationDAO thresholdConfigurationDAO;
    @EJB
    private PropertyDAO propertyDAO;
    @Resource
    private ClusterService clusterService;
    @Resource
    @OptionalDependency
    private TimerService timerService;
    private ClusterChannel channel;
    private final ReentrantReadWriteLock findAllLock = new ReentrantReadWriteLock();
    private List<Profile> findAllProfiles;
    private Cache<Long, Profile> cache;
    private final List<ProfileListener> profileListeners = new CopyOnWriteArrayList<ProfileListener>();
    private static final String SERVICE_AUTHORIZATION = "Authorization";

    @Override
    public Profile find(long id) {
        Profile profile = this.cache.getByPrimaryId(id);
        if (profile == null && (profile = this.findUncached(id)) != null) {
            this.loadCache(profile);
        }
        return profile;
    }

    @VisibleForTesting
    Profile findUncached(long id) {
        return (Profile)this.find(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.ID) + " = ?", new Object[]{id});
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return true;
    }

    public boolean isUpdatable() {
        return true;
    }

    @Override
    public Profile create(Profile profile) {
        this.checkProfileName(profile);
        super.create((BaseEntity)profile);
        this.updateCache(profile);
        this.transactionManager.afterCompletion(t -> this.resetReadOnlyCache());
        return profile;
    }

    private void resetReadOnlyCache() {
        this.findAllLock.writeLock().lock();
        try {
            this.findAllProfiles = null;
        }
        finally {
            this.findAllLock.writeLock().unlock();
        }
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Profile profile = (Profile)baseEntity;
        int i = 1;
        preparedStatement.setString(i++, profile.getName());
        preparedStatement.setDouble(i++, profile.getProfileVersion());
        int fingerprintIndex = TableColumn.FINGERPRINT.index();
        return this.assignFingerprint(preparedStatement, fingerprintIndex, new Object[]{profile.getName(), BigDecimal.valueOf(profile.getProfileVersion())});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Profile profile = (Profile)baseEntity;
        profile.setName(resultSet.getString("name"));
        profile.setProfileVersion(resultSet.getDouble("profileVersion"));
        Map<ProfileService, Long> allServices = this.profileServiceDAO.findAllServices(profile);
        Map<Long, List<IndividualCounterConfiguration>> individualCounterConfigurations = this.individualCounterConfigurationManager.findAllCounterConfigurations(profile);
        Map<Long, List<Property>> allProperties = this.propertyDAO.findAllProperties(profile);
        Map<Long, List<ThresholdConfiguration>> allThresholds = this.thresholdConfigurationDAO.findAllThresholdConfigurations(profile);
        LinkedList<ProfileService> profileServices = new LinkedList<ProfileService>();
        for (Map.Entry<ProfileService, Long> entry : allServices.entrySet()) {
            ProfileService service = entry.getKey();
            if (entry.getValue() == null) {
                this.visit(service, allServices, individualCounterConfigurations, allProperties, allThresholds);
                profileServices.add(service);
            }
            this.updateService(service, individualCounterConfigurations, allProperties, allThresholds);
        }
        profile.setServices(profileServices);
        profile.setVersion(resultSet.getLong("version"));
    }

    private List<SharedCounterConfiguration> getSharedCounterConfigurations(List<ProfileCounterRelation> profileCounterRelations) {
        return profileCounterRelations.stream().map(ProfileCounterRelation::getCounterConfigurationName).map(name -> this.sharedCounterConfigurationDAO.findByName((String)name)).collect(Collectors.toList());
    }

    private void updateService(ProfileService service, Map<Long, List<IndividualCounterConfiguration>> individualCounterConfigurations, Map<Long, List<Property>> allProperties, Map<Long, List<ThresholdConfiguration>> allThresholds) {
        List counterConfigurations = individualCounterConfigurations.computeIfAbsent(service.getId(), k -> new LinkedList());
        for (IndividualCounterConfiguration cc : counterConfigurations) {
            cc.setService(service);
        }
        service.setIndividualCounterConfigurations(counterConfigurations);
        if (SERVICE_AUTHORIZATION.equals(service.getName())) {
            List<ProfileCounterRelation> profileCounterRelations = this.profileCounterRelationDAO.findRelationByProfileService(service.getId());
            service.setSharedCounterConfigurations(this.getSharedCounterConfigurations(profileCounterRelations));
            service.setSharedCounterOverrides(profileCounterRelations.stream().map(it -> SharedCounterOverride.newBuilder().name(it.getCounterConfigurationName()).limit(it.getCounterConfigurationLimit()).build()).collect(Collectors.toList()));
        }
        List properties = allProperties.computeIfAbsent(service.getId(), k -> new LinkedList());
        properties.forEach(p -> p.setService(service));
        service.setProperties(properties);
        List thresholdConfigurations = allThresholds.computeIfAbsent(service.getId(), k -> new LinkedList());
        thresholdConfigurations.forEach(tc -> tc.setService(service));
        service.setThresholdConfigurations(thresholdConfigurations);
    }

    protected Profile createManagedEntity() {
        return new Profile();
    }

    @Override
    public Profile update(Profile profile) {
        this.updateCache(profile);
        this.transactionManager.afterCompletion(t -> this.resetReadOnlyCache());
        Profile updatedProfile = (Profile)super.updateWithVersionCheck((BaseEntity)profile);
        this.profileListeners.forEach(listener -> listener.onProfileUpdated(updatedProfile));
        return updatedProfile;
    }

    @Override
    public Profile findByName(String name) {
        Profile profile = this.cache.getBySecondaryId(ProfileSecondaryCache.NAME, name);
        if (profile == null && (profile = (Profile)this.find(this.getSelectStatement() + " where name = ?", new Object[]{name})) != null) {
            this.loadCache(profile);
        }
        return profile;
    }

    @Override
    public List<Profile> findAll() {
        Measurement measurement = this.statisticsService.startMeasurment("profile", "findAll", StatisticsService.MeasurementType.INTERNAL);
        try {
            List<Profile> list = this.findForeignKeys("select " + String.valueOf((Object)TableColumn.ID) + " from hier$profile", "id", new Object[0]).stream().map(this::find).collect(Collectors.toList());
            return list;
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    public List<Profile> findAllReadOnly() {
        Measurement measurement = this.statisticsService.startMeasurment("profile", "findAllReadOnly", StatisticsService.MeasurementType.INTERNAL);
        this.findAllLock.readLock().lock();
        try {
            if (this.findAllProfiles == null) {
                this.findAllLock.readLock().unlock();
                this.findAllLock.writeLock().lock();
                try {
                    if (this.findAllProfiles == null) {
                        this.findAllProfiles = this.findAll();
                    }
                    this.findAllLock.readLock().lock();
                }
                finally {
                    this.findAllLock.writeLock().unlock();
                }
            }
            LinkedList<Profile> linkedList = new LinkedList<Profile>(this.findAllProfiles);
            return linkedList;
        }
        finally {
            this.findAllLock.readLock().unlock();
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    public long countAllByType(String profileType) {
        List<Profile> profiles = this.findAll();
        return profiles.stream().filter(profile -> profile.hasProfileType(profileType)).count();
    }

    @Override
    public List<Profile> findByPermission(String permission) {
        return this.findForeignKeys("select distinct hp.ID as id, hp.NAME, hp.PROFILEVERSION, hp.FINGERPRINT, hp.FINGERPRINTVERSION, hp.FINGERPRINTKEYGENERATION, hp.VERSION FROM hier$profile hp inner join HIER$SERVICE hs on hp.id=hs.fk_profile WHERE hs." + TableColumn.NAME.name() + " = ?", "id", new Object[]{permission}).stream().map(this::find).collect(Collectors.toList());
    }

    protected void updateCache(Profile profile) {
        logger.trace("Updating cache for profile {}", (Object)profile.getName());
        this.cache.update(profile.getId(), profile, new SecondaryCache[]{ProfileSecondaryCache.NAME}, new String[]{profile.getName()}, LockingType.optimistic);
    }

    protected void loadCache(Profile profile) {
        logger.trace("Loading cache for profile {}", (Object)profile.getName());
        this.cache.load(profile.getId(), profile, new SecondaryCache[]{ProfileSecondaryCache.NAME}, new String[]{profile.getName()});
    }

    @Override
    public void loadCache() {
        try {
            this.batchCreator.submit(new BatchConfiguration.BatchBuilderBuilder().name("profile").quiet(true).dataConsumer(entity -> {
                this.find((long)entity);
                return DataConsumer.BatchEntityStatus.SUCCESS;
            }).dataIterator(callback -> this.findForeignKeys("select " + String.valueOf((Object)TableColumn.ID) + " from hier$profile", "id", new Object[0]).forEach(arg_0 -> ((BatchCallback)callback).next(arg_0))).batchSize(10).parallelDegree(4).build());
        }
        catch (JobRejectedException e) {
            logger.warn("Could not load profiles", e);
        }
    }

    @PostConstruct
    public void postConstruct() throws ClusterException {
        this.cache = this.cacheService.createCache(Long.class, Profile.class, false);
        this.cache.addSecondaryCache(ProfileSecondaryCache.NAME);
        this.cache.setSwapFunction(id -> {
            try {
                if (this.loading.add((Long)id)) {
                    CompletableFuture<CacheSwapResult> future = CompletableFuture.supplyAsync(() -> this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> {
                        Profile profile = this.findUncached((long)id);
                        logger.info("Swapping profile cache {}", (Object)profile.getName());
                        return CacheSwapResult.newBuilder(Profile.class).object(profile).secondaryCaches(new SecondaryCache[]{ProfileSecondaryCache.NAME}).secondaryIds(new String[]{profile.getName()}).build();
                    }), this.jobExecutorService);
                    future.whenComplete((result, throwable) -> this.loading.remove(id));
                    return future;
                }
                return null;
            }
            catch (Exception e) {
                this.loading.remove(id);
                return CompletableFuture.failedFuture(e);
            }
        });
        this.cache.registerOnRemoveAction(id -> this.resetReadOnlyCache());
        if (this.timerService != null) {
            this.timerService.registerTimerListener(TimerRegistration.newBuilder().beanId(this.applicationContext.getBeanId()).pattern("0 * * * *").timerCondition(TimerCondition.ALL_NODES).timerListener(this).build());
        }
    }

    @Override
    public void delete(Profile profile) {
        for (ProfileService profileService : profile.getServices()) {
            this.profileServiceDAO.deleteCascade(profileService);
            this.cache.remove(profile.getId());
        }
        super.delete("delete from hier$profile where " + String.valueOf((Object)TableColumn.ID) + " = ?", new Object[]{profile.getId()});
        this.profileListeners.forEach(listener -> listener.onProfileDeleted(profile));
    }

    @Override
    public void selectiveClean(CacheCleaner<Profile> cleaner) {
        this.cache.selectiveClean(cleaner);
    }

    @Override
    public void clearCacheForProfile(Profile profile) {
        this.cache.remove(profile.getId());
    }

    @Override
    public void precacheProfile(Profile profile) {
        this.updateCache(profile.deepClone());
    }

    private void visit(ProfileService parent, Map<ProfileService, Long> allServices, Map<Long, List<IndividualCounterConfiguration>> individualCounterConfigurations, Map<Long, List<Property>> allProperties, Map<Long, List<ThresholdConfiguration>> allThresholds) {
        LinkedList<ProfileService> children = new LinkedList<ProfileService>();
        for (Map.Entry<ProfileService, Long> child : allServices.entrySet()) {
            if (child.getValue() == null || !child.getValue().equals(parent.getId())) continue;
            ProfileService childService = child.getKey();
            this.updateService(childService, individualCounterConfigurations, allProperties, allThresholds);
            childService.setParent(parent);
            children.add(childService);
            this.visit(childService, allServices, individualCounterConfigurations, allProperties, allThresholds);
        }
        if (!children.isEmpty()) {
            parent.setChildren(children);
        }
    }

    @Override
    public void registerListener(ProfileListener profileListener) {
        this.profileListeners.add(profileListener);
    }

    @Override
    public void removeListener(ProfileListener profileListener) {
        this.profileListeners.remove(profileListener);
    }

    protected String getEntitySimpleName() {
        return Profile.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.NAME.name()), resultSet.getBigDecimal(TableColumn.PROFILEVERSION.name())};
        }
        return null;
    }

    @Override
    public void onTimeout() {
        try {
            this.batchCreator.submit(new BatchConfiguration.BatchBuilderBuilder().name("profile").quiet(true).dataConsumer(id -> {
                Profile profile = (Profile)super.find(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.ID) + " = ?", new Object[]{id});
                Profile current = this.cache.getByPrimaryId((Long)id);
                if (current != null && current.getVersion() < profile.getVersion()) {
                    logger.info("Found stale profile in cache {}", (Object)profile.getName());
                    this.cache.remove((Long)id);
                }
                return DataConsumer.BatchEntityStatus.SUCCESS;
            }).dataIterator(callback -> this.findMultiple(this.getSelectStatement(), new Object[0]).stream().map(BaseEntity::getId).collect(Collectors.toList()).forEach(arg_0 -> ((BatchCallback)callback).next(arg_0))).batchSize(10).parallelDegree(4).build()).get();
        }
        catch (JobRejectedException | InterruptedException | ExecutionException e) {
            logger.trace("Could not force update profile cache", e);
        }
    }

    protected void checkProfileName(Profile profile) {
        if (this.findByName(profile.getName()) != null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_ALREADY_EXISTS).add("name", profile.getName()).add("message", "Profile already exists").create();
        }
    }

    @Override
    public void clearPrimaryAndTransactionCache(Long id) {
        this.cache.remove(id);
    }

    public Profile updateDefaultFingerprint(Profile entry) {
        return Optional.ofNullable(entry).map(entity -> (Profile)this.updateWithVersionAndFingerprintVersionCheck((BaseEntity)entity, 1)).orElse(entry);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    @VisibleForTesting
    void setJobExecutorService(JobExecutorService jobExecutorService) {
        this.jobExecutorService = jobExecutorService;
    }

    private static enum TableColumn {
        ID,
        NAME,
        PROFILEVERSION,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION,
        VERSION;


        int index() {
            return this.ordinal();
        }
    }

    static enum ProfileSecondaryCache implements SecondaryCache
    {
        NAME("name");

        private final String name;

        private ProfileSecondaryCache(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

