/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.Period;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PreUpdate;

@MappedSuperclass
public abstract class Periodizable
extends Period {
    private static final long serialVersionUID = 1L;
    protected PeriodType periodType = PeriodType.NO_PERIOD;
    protected boolean balanceReuseable;
    protected int periodLength;
    protected int startDayInMonth;

    public Periodizable() {
    }

    protected Periodizable(Periodizable periodizable) {
        super(periodizable);
        this.periodType = periodizable.getPeriodType();
        this.balanceReuseable = periodizable.isBalanceReuseable();
        this.periodLength = periodizable.getPeriodLength();
        this.startDayInMonth = periodizable.getStartDayInMonth();
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public void setPeriodLength(int periodLength) {
        this.periodLength = periodLength;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public boolean isBalanceReuseable() {
        return this.balanceReuseable;
    }

    public void setBalanceReuseable(boolean balanceReuseable) {
        this.balanceReuseable = balanceReuseable;
    }

    public int getStartDayInMonth() {
        return this.startDayInMonth;
    }

    public void setStartDayInMonth(int startDayInMonth) {
        this.startDayInMonth = startDayInMonth;
    }

    @PreUpdate
    public void validate() {
        if (this.periodType == PeriodType.NO_PERIOD) {
            this.balanceReuseable = true;
        }
        switch (this.periodType.ordinal()) {
            case 4: {
                if (this.startDayInMonth < 1 || this.startDayInMonth > 28) {
                    throw new IllegalArgumentException("Start day in month can not be less than 1 or larger than 28");
                }
                if (this.periodLength == 0) break;
                throw new IllegalArgumentException("Period length not applicable to financial calendar");
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                if (this.periodLength > 1 && this.startDateTime == null) {
                    throw new IllegalArgumentException("Start date time must be set");
                }
                if (this.startDayInMonth != 0) {
                    throw new IllegalArgumentException("Start day in month is not applicable to other period types than Financial month");
                }
                if (this.periodLength >= 1) break;
                throw new IllegalArgumentException("Period length must be at least 1");
            }
            case 5: 
            case 6: {
                if (this.periodLength >= 1) break;
                throw new IllegalArgumentException("Period length must be at least 1");
            }
        }
    }

    public static enum PeriodType {
        NO_PERIOD,
        CALENDAR_MONTH,
        CALENDAR_WEEK,
        DAY,
        FINANCIAL_CALENDAR,
        MINUTE,
        HOUR,
        CALENDAR_YEAR;

    }
}

