/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.counters.PersonalLimitsManager;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterIdentifierMatchParameters;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRuleDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationFPDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.PeriodizableManagerBean;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.m3if.admin.common.CounterIdValue;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cache.CacheableList;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.UniqueConstraintViolatedException;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.counterconfiguration.S"})
public class IndividualCounterConfigurationDAOBean
extends PeriodizableManagerBean<IndividualCounterConfiguration>
implements IndividualCounterConfigurationDAO {
    static final String FINGERPRINT_KEY = "hier.counterconfiguration.S";
    private static final int CURRENT_FINGERPRINT_VERSION = 3;
    private static final String TABLE_NAME = "hier$counterconfiguration";
    private static final String TABLE_SEQUENCE_NAME = "hier$counterconfiguration_seq";
    private static final String IDENTIFIER_KEY = "IDENTIFIER_";
    private static final String PROFILE_KEY = "PROFILE_";
    private Cache<String, CacheableList<IndividualCounterConfiguration>> counterConfigurationCache;
    @EJB
    private ModifierConfigurationDAO modifierConfigurationManager;
    @EJB
    private ProfileServiceDAO serviceDAO;
    @EJB
    private CounterMatchRuleDAO counterMatchRuleDAO;
    @Resource
    private ApplicationContext applicationContext;
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    @EJB
    private PersonalLimitsManager personalLimitsManager;
    @Resource
    private CacheService cacheService;

    @Override
    public int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        IndividualCounterConfiguration individualCounterConfiguration = (IndividualCounterConfiguration)baseEntity;
        DateTime startDateTime = individualCounterConfiguration.getStartDateTime();
        DateTime endDateTime = individualCounterConfiguration.getEndDateTime();
        int i = 1;
        preparedStatement.setString(i++, individualCounterConfiguration.getCounterType().getName());
        if (startDateTime != null) {
            preparedStatement.setObject(i++, (Object)IndividualCounterConfigurationDAOBean.getTimestamp((DateTime)startDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (endDateTime != null) {
            preparedStatement.setObject(i++, (Object)IndividualCounterConfigurationDAOBean.getTimestamp((DateTime)endDateTime), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setInt(i++, individualCounterConfiguration.getPeriodType().ordinal());
        preparedStatement.setString(i++, individualCounterConfiguration.isBalanceReuseable() ? "Y" : "N");
        preparedStatement.setInt(i++, individualCounterConfiguration.getPeriodLength());
        preparedStatement.setInt(i++, individualCounterConfiguration.getStartDayInMonth());
        preparedStatement.setString(i++, individualCounterConfiguration.getName());
        preparedStatement.setString(i++, individualCounterConfiguration.getExternalId());
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, individualCounterConfiguration.hasUnit() ? individualCounterConfiguration.getUnit().getValue() : null);
        preparedStatement.setInt(i++, individualCounterConfiguration.getDynamicType().ordinal());
        preparedStatement.setInt(i++, individualCounterConfiguration.getDynamicLength());
        preparedStatement.setLong(i++, individualCounterConfiguration.getService().getId());
        preparedStatement.setString(i++, individualCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N");
        preparedStatement.setString(i++, individualCounterConfiguration.getHardLimitNotificationOperationTypeName());
        preparedStatement.setString(i++, individualCounterConfiguration.getDescription());
        preparedStatement.setString(i++, individualCounterConfiguration.getIdentifier());
        preparedStatement.setBigDecimal(i++, individualCounterConfiguration.getDefaultValue());
        preparedStatement.setBoolean(i++, individualCounterConfiguration.isPersonalizedLimitAllowed());
        return this.assignFingerprint(preparedStatement, i, new Object[]{individualCounterConfiguration.getCounterType().getName(), IndividualCounterConfigurationDAOBean.getTimestamp((DateTime)startDateTime), IndividualCounterConfigurationDAOBean.getTimestamp((DateTime)endDateTime), individualCounterConfiguration.getPeriodType().ordinal(), individualCounterConfiguration.isBalanceReuseable() ? "Y" : "N", individualCounterConfiguration.getPeriodLength(), individualCounterConfiguration.getStartDayInMonth(), individualCounterConfiguration.getName(), individualCounterConfiguration.getExternalId(), individualCounterConfiguration.getUnit().getValue(), individualCounterConfiguration.getDynamicType().ordinal(), individualCounterConfiguration.getDynamicLength(), individualCounterConfiguration.getService().getId(), individualCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N", individualCounterConfiguration.getHardLimitNotificationOperationTypeName(), individualCounterConfiguration.getDescription(), individualCounterConfiguration.getIdentifier(), individualCounterConfiguration.getDefaultValue(), individualCounterConfiguration.isPersonalizedLimitAllowed()});
    }

    @Override
    public IndividualCounterConfiguration find(long id) {
        IndividualCounterConfiguration individualCounterConfiguration;
        List counterConfigurationList = this.counterConfigurationCache.getByPrimaryId(String.valueOf(id));
        IndividualCounterConfiguration individualCounterConfiguration2 = individualCounterConfiguration = counterConfigurationList != null && !counterConfigurationList.isEmpty() ? (IndividualCounterConfiguration)counterConfigurationList.get(0) : null;
        if ((counterConfigurationList == null || counterConfigurationList.isEmpty()) && (individualCounterConfiguration = (IndividualCounterConfiguration)this.find(this.getSelectStatement() + " where id = ?", new Object[]{id})) != null) {
            individualCounterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules(individualCounterConfiguration));
            this.updateCacheByPrimaryKey(individualCounterConfiguration);
        }
        return individualCounterConfiguration;
    }

    @PostConstruct
    public void postConstruct() {
        this.counterConfigurationCache = this.cacheService.createListCache(String.class, IndividualCounterConfiguration.class, true);
    }

    @Override
    public IndividualCounterConfiguration update(IndividualCounterConfiguration counterConfiguration) {
        try {
            IndividualCounterConfiguration updated = (IndividualCounterConfiguration)super.update((BaseEntity)counterConfiguration);
            this.counterMatchRuleDAO.setMatchRules(counterConfiguration.getMatchRules(), updated);
            this.serviceDAO.update(counterConfiguration.getService());
            this.removeFromCache(updated);
            return updated;
        }
        catch (UniqueConstraintViolatedException e) {
            if (e.getMessage().toLowerCase().contains("counterconf_iden_ix")) {
                ValidationException validationException = new ValidationException("identifier constraint violation");
                validationException.getArguments().put("identifier", String.format("%s already exist for this profile", counterConfiguration.getIdentifier()));
                throw validationException;
            }
            throw e;
        }
    }

    @Override
    public void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        IndividualCounterConfiguration individualCounterConfiguration = (IndividualCounterConfiguration)baseEntity;
        String counterTypeStr = MoreObjects.firstNonNull(resultSet.getString("counterType"), CounterConfiguration.NoCounterType.NONE.getName());
        CounterType counterType = this.counterTypeRegistry.getCounterType(counterTypeStr).orElseThrow(() -> new IllegalArgumentException("Unable to find counter type " + counterTypeStr));
        individualCounterConfiguration.setCounterType(counterType);
        individualCounterConfiguration.setName(resultSet.getString("name"));
        individualCounterConfiguration.setExternalId(resultSet.getString("externalid"));
        IndividualCounterConfigurationDAOBean.handleLegacyUnitTypeField(resultSet, individualCounterConfiguration);
        int dynamicTypeOrdinal = resultSet.getInt("dynamictype");
        for (CounterConfiguration.DynamicType dynamicType : CounterConfiguration.DynamicType.values()) {
            if (dynamicType.ordinal() != dynamicTypeOrdinal) continue;
            individualCounterConfiguration.setDynamicType(dynamicType);
            break;
        }
        individualCounterConfiguration.setDynamicLength(resultSet.getInt("dynamiclength"));
        individualCounterConfiguration.setModifierConfigurations(this.modifierConfigurationManager.findModifierConfigurations(individualCounterConfiguration));
        individualCounterConfiguration.setHardLimitNotificationsEnabled(resultSet.getString("hardlimitnotificationsenabled").equals("Y"));
        individualCounterConfiguration.setHardLimitNotificationOperationTypeName(resultSet.getString("hardlimitnotificationname"));
        individualCounterConfiguration.setDescription(resultSet.getString("description"));
        individualCounterConfiguration.setIdentifier(resultSet.getString("identifier"));
        individualCounterConfiguration.setUnit(Unit.fromString(resultSet.getString("unit")));
        individualCounterConfiguration.setDefaultValue(resultSet.getBigDecimal("defaultvalue"));
        individualCounterConfiguration.setPersonalizedLimitAllowed(resultSet.getBoolean("allowpersonallimit"));
        IndividualCounterConfigurationDAOBean.handleLegacyModifierUnitTypeField(resultSet, individualCounterConfiguration);
    }

    private static void handleLegacyUnitTypeField(ResultSet resultSet, CounterConfiguration counterConfiguration) throws SQLException {
        String unitType = resultSet.getString("unittype");
        if (Strings.isNullOrEmpty(unitType)) {
            return;
        }
        counterConfiguration.setCounterType(LegacyLimitsConverter.extractCounterTypeFrom(unitType));
        counterConfiguration.setMatchRules(LegacyLimitsConverter.convertToCounterMatchRules(unitType));
    }

    private static void handleLegacyModifierUnitTypeField(ResultSet resultSet, CounterConfiguration counterConfiguration) throws SQLException {
        String modifierUnitType = resultSet.getString("modifierunittype");
        List<ModifierMatchRule> matchRules = LegacyLimitsConverter.convertToModifierMatchRules(modifierUnitType);
        if (!matchRules.isEmpty()) {
            counterConfiguration.getModifierConfigurations().forEach(mc -> mc.setMatchRules(matchRules));
        }
    }

    public IndividualCounterConfiguration createManagedEntity() {
        return new IndividualCounterConfiguration();
    }

    @Override
    public IndividualCounterConfiguration create(IndividualCounterConfiguration counterConfiguration, ProfileService profileService) {
        try {
            LinkedList<IndividualCounterConfiguration> counterConfigurations = new LinkedList<IndividualCounterConfiguration>(profileService.getIndividualCounterConfigurations());
            if (counterConfigurations.contains(counterConfiguration)) {
                throw new IllegalArgumentException();
            }
            counterConfiguration.setService(profileService);
            super.create((BaseEntity)counterConfiguration);
            counterConfiguration.setMatchRules(this.counterMatchRuleDAO.setMatchRules(counterConfiguration.getMatchRules(), counterConfiguration));
            counterConfigurations.add(counterConfiguration);
            profileService.setIndividualCounterConfigurations(Collections.unmodifiableList(counterConfigurations));
            this.serviceDAO.update(profileService);
            this.removeFromCacheByProfile(counterConfiguration);
            this.removeFromCacheByIdentifier(counterConfiguration);
            return counterConfiguration;
        }
        catch (UniqueConstraintViolatedException e) {
            if (e.getMessage().toLowerCase().contains("counterconf_iden_ix")) {
                ValidationException validationException = new ValidationException("identifier constraint violation");
                validationException.getArguments().put("identifier", String.format("%s already exist for this profile", counterConfiguration.getIdentifier()));
                throw validationException;
            }
            throw e;
        }
    }

    private void updateCacheByIdentifier(List<IndividualCounterConfiguration> counterConfigurations, String identifier) {
        if (this.counterConfigurationCache != null) {
            this.counterConfigurationCache.update(IDENTIFIER_KEY + identifier, new CacheableList<IndividualCounterConfiguration>(counterConfigurations));
        }
    }

    protected void updateCacheByProfile(List<IndividualCounterConfiguration> counterConfigurations, ProfileService profileService) {
        if (this.counterConfigurationCache != null) {
            this.counterConfigurationCache.update(PROFILE_KEY + profileService.getId(), new CacheableList<IndividualCounterConfiguration>(counterConfigurations));
        }
    }

    protected void updateCacheByPrimaryKey(IndividualCounterConfiguration counterConfiguration) {
        List<IndividualCounterConfiguration> counterConfigurations = Arrays.asList(counterConfiguration);
        if (this.counterConfigurationCache != null) {
            this.counterConfigurationCache.update(String.valueOf(counterConfiguration.getId()), new CacheableList<IndividualCounterConfiguration>(counterConfigurations));
        }
    }

    protected void removeFromCache(IndividualCounterConfiguration counterConfiguration) {
        this.removeFromCacheByPrimaryKey(counterConfiguration);
        this.removeFromCacheByIdentifier(counterConfiguration);
        this.removeFromCacheByProfile(counterConfiguration);
    }

    protected void removeFromCacheByProfile(IndividualCounterConfiguration counterConfiguration) {
        if (this.counterConfigurationCache != null && counterConfiguration.getService() != null) {
            this.counterConfigurationCache.remove(PROFILE_KEY + counterConfiguration.getService().getId());
        }
    }

    protected void removeFromCacheByIdentifier(IndividualCounterConfiguration counterConfiguration) {
        if (this.counterConfigurationCache != null) {
            this.counterConfigurationCache.remove(IDENTIFIER_KEY + counterConfiguration.getIdentifier());
        }
    }

    protected void removeFromCacheByPrimaryKey(IndividualCounterConfiguration counterConfiguration) {
        if (this.counterConfigurationCache != null) {
            this.counterConfigurationCache.remove(String.valueOf(counterConfiguration.getId()));
        }
    }

    @Override
    public List<IndividualCounterConfiguration> findByService(ProfileService profileService) {
        List counterConfigurations = this.counterConfigurationCache.getByPrimaryId(PROFILE_KEY + profileService.getId());
        if (counterConfigurations == null || counterConfigurations.isEmpty()) {
            counterConfigurations = this.findMultiple(this.getSelectStatement() + " where fk_service = ? order by id", new Object[]{profileService.getId()});
            for (IndividualCounterConfiguration counterConfiguration : counterConfigurations) {
                counterConfiguration.setService(profileService);
                counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules(counterConfiguration));
            }
            this.updateCacheByProfile(counterConfigurations, profileService);
        }
        return Collections.unmodifiableList(counterConfigurations);
    }

    @Override
    public List<IndividualCounterConfiguration> findByIdentifier(String identifier) {
        List counterConfigurations = this.counterConfigurationCache.getByPrimaryId(IDENTIFIER_KEY + identifier);
        if (counterConfigurations == null || counterConfigurations.isEmpty()) {
            counterConfigurations = this.findMultiple(this.getSelectStatement() + " where identifier = ? order by id", new Object[]{identifier});
            counterConfigurations.stream().forEach(counterConfiguration -> counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules((CounterConfiguration)counterConfiguration)));
            this.updateCacheByIdentifier(counterConfigurations, identifier);
        }
        return Collections.unmodifiableList(counterConfigurations);
    }

    @Override
    public List<IndividualCounterConfiguration> findByIdentifierAndCounterId(String identifier, CounterIdValue counterId) {
        List counterConfigurations = null;
        if (counterId != null) {
            counterConfigurations = this.findMultiple(this.getSelectStatement() + " where identifier = ? and id = ?", new Object[]{identifier, counterId.getValueAsString()});
        }
        if ((counterConfigurations == null || counterConfigurations.isEmpty()) && ((counterConfigurations = (List)this.counterConfigurationCache.getByPrimaryId(IDENTIFIER_KEY + identifier)) == null || counterConfigurations.isEmpty())) {
            counterConfigurations = this.findMultiple(this.getSelectStatement() + " where identifier = ?", new Object[]{identifier});
            this.updateCacheByIdentifier(counterConfigurations, identifier);
        }
        return Collections.unmodifiableList(counterConfigurations);
    }

    @Override
    public List<IndividualCounterConfiguration> findByMatchingAttributes(CounterIdentifierMatchParameters params) {
        List counterConfigurations = params.getUnit().equals(Unit.NONE) ? this.findMultiple(this.getSelectStatement() + " where counterType = ? and unit IS NULL and periodType = ? and periodLength = ?", new Object[]{params.getCounterType().getName(), params.getPeriodType().ordinal(), params.getPeriodLength()}) : this.findMultiple(this.getSelectStatement() + " where counterType = ? and unit = ? and periodType = ? and periodLength = ?", new Object[]{params.getCounterType().getName(), params.getUnit().getValue(), params.getPeriodType().ordinal(), params.getPeriodLength()});
        counterConfigurations.stream().forEach(counterConfiguration -> counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules((CounterConfiguration)counterConfiguration)));
        return Collections.unmodifiableList(counterConfigurations);
    }

    @Override
    public Map<Long, List<IndividualCounterConfiguration>> findAllCounterConfigurations(Profile profile) {
        HashMap<Long, List<IndividualCounterConfiguration>> allCounterConfigurations = new HashMap<Long, List<IndividualCounterConfiguration>>();
        String statement = this.getSelectStatement() + " where fk_service in (select id from hier$service where fk_profile = ?) order by id";
        Measurement measurement = this.statisticsService.startMeasurment("sql", statement, StatisticsService.MeasurementType.OUTGOING);
        try (Connection connection = this.dataSource.getReadOnlyConnection(this.getPreferredConnectionType());
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            preparedStatement.setLong(1, profile.getId());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    IndividualCounterConfiguration counterConfiguration = new IndividualCounterConfiguration();
                    this.assign((BaseEntity)counterConfiguration, resultSet);
                    allCounterConfigurations.computeIfAbsent(resultSet.getLong("fk_service"), k -> new LinkedList()).add(counterConfiguration);
                    counterConfiguration.setMatchRulesIfNotUpgraded(this.counterMatchRuleDAO.getMatchRules(counterConfiguration));
                }
            }
        }
        catch (SQLException e) {
            measurement.setError();
            throw new PersistenceException(String.format("Error while executing: %s parameters %s", statement, profile.getId()), e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
        return allCounterConfigurations;
    }

    @Override
    @VisibleForTesting
    public List<IndividualCounterConfiguration> getCacheData(String key) {
        return this.counterConfigurationCache.getByPrimaryId(key);
    }

    @Override
    public void delete(IndividualCounterConfiguration counterConfiguration) {
        List<ModifierConfiguration> theModifiers = counterConfiguration.getModifierConfigurations();
        for (ModifierConfiguration theModifier : theModifiers) {
            this.modifierConfigurationManager.delete(theModifier);
        }
        super.delete((BaseEntity)counterConfiguration);
        ProfileService service = counterConfiguration.getService();
        LinkedList<IndividualCounterConfiguration> counters = new LinkedList<IndividualCounterConfiguration>(service.getIndividualCounterConfigurations());
        counters.remove(counterConfiguration);
        service.setIndividualCounterConfigurations(Collections.unmodifiableList(counters));
        this.serviceDAO.update(service);
        this.counterMatchRuleDAO.deleteCascade(counterConfiguration);
        this.personalLimitsManager.deleteByCounterConfiguration(counterConfiguration);
        this.removeFromCache(counterConfiguration);
    }

    @Override
    public void deleteByService(ProfileService profileService) {
        List<IndividualCounterConfiguration> counterConfigurations = this.findByService(profileService);
        for (CounterConfiguration counterConfiguration : counterConfigurations) {
            super.delete((BaseEntity)((IndividualCounterConfiguration)counterConfiguration));
            this.counterMatchRuleDAO.deleteCascade(counterConfiguration);
            this.personalLimitsManager.deleteByCounterConfiguration(counterConfiguration);
            this.removeFromCache((IndividualCounterConfiguration)counterConfiguration);
        }
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return IndividualCounterConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 3;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), resultSet.getInt(TableColumn.DYNAMICTYPE.name()), resultSet.getInt(TableColumn.DYNAMICLENGTH.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.IDENTIFIER.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name())};
        }
        if (fingerprintVersion == 3) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), resultSet.getInt(TableColumn.DYNAMICTYPE.name()), resultSet.getInt(TableColumn.DYNAMICLENGTH.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.IDENTIFIER.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name()), resultSet.getBoolean(TableColumn.ALLOWPERSONALLIMIT.name())};
        }
        return null;
    }

    public Class<? extends CryptoExtendedBaseEntityDAOBean> getDaoBeanForUpdateFpCli() {
        return IndividualCounterConfigurationFPDAOBean.class;
    }

    private static enum TableColumn {
        ID,
        COUNTERTYPE,
        STARTDATETIME,
        ENDDATETIME,
        PERIODTYPE,
        BALANCEREUSEABLE,
        PERIODLENGTH,
        STARTDAYINMONTH,
        NAME,
        EXTERNALID,
        UNITTYPE,
        MODIFIERUNITTYPE,
        UNIT,
        DYNAMICTYPE,
        DYNAMICLENGTH,
        FK_SERVICE,
        HARDLIMITNOTIFICATIONSENABLED,
        HARDLIMITNOTIFICATIONNAME,
        DESCRIPTION,
        IDENTIFIER,
        DEFAULTVALUE,
        ALLOWPERSONALLIMIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

