/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cacheable;
import com.ericsson.lwac.persistence.DeepCloneable;
import jakarta.persistence.Entity;

@Entity
public class IndividualCounterConfiguration
extends CounterConfiguration
implements DeepCloneable<IndividualCounterConfiguration>,
Cacheable<IndividualCounterConfiguration> {
    @JsonMapper.NotMapped
    private ProfileService profileService;
    @JsonMapper.NotMapped
    private long version = 1L;
    private String identifier;

    @Override
    public CounterConfiguration.CounterConfigurationType getCounterConfigurationType() {
        return CounterConfiguration.CounterConfigurationType.INDIVIDUAL;
    }

    public IndividualCounterConfiguration() {
    }

    public IndividualCounterConfiguration(String name) {
        this.name = name;
    }

    IndividualCounterConfiguration(IndividualCounterConfiguration individualCounterConfiguration) {
        super(individualCounterConfiguration);
        this.profileService = individualCounterConfiguration.profileService;
        this.identifier = individualCounterConfiguration.identifier;
    }

    public ProfileService getService() {
        return this.profileService;
    }

    public void setService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public boolean matchesOnIdentifier(IndividualCounterConfiguration other) {
        return this.getIdentifier() != null && other.getIdentifier() != null && this.getIdentifier().equals(other.getIdentifier());
    }

    @Override
    public void validate() {
        super.validate();
        if (this.profileService == null) {
            throw new ValidationException("ProfileService not set");
        }
    }

    @Override
    public IndividualCounterConfiguration deepClone() {
        return new IndividualCounterConfiguration(this);
    }

    public boolean isSimilarTo(IndividualCounterConfiguration other) {
        if (!super.isSimilarTo(other)) {
            return false;
        }
        return this.profileService == null || other.profileService == null || this.profileService.equals(other.profileService);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }
}

