/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.MatchRule;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractMatchRuleDAOBean<S extends BaseEntity, T extends MatchRule<T>>
extends CryptoExtendedBaseEntityDAOBean<T> {
    private static final short TRUE = 1;
    private static final short FALSE = 0;
    static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final List<TableColumn> TABLE_COLUMNS = Lists.newArrayList(TableColumn.values());

    AbstractMatchRuleDAOBean() {
    }

    public List<T> getMatchRules(S owner) {
        Preconditions.checkNotNull(owner);
        return this.findMultiple(this.getSelectStatement() + " where " + this.getForeignKeyColumn() + " = ?", new Object[]{owner.getId()}).stream().map(this.setOwner(owner)).collect(Collectors.toList());
    }

    public List<T> setMatchRules(List<T> matchRules, S owner) {
        Preconditions.checkNotNull(matchRules);
        this.deleteCascade(owner);
        return matchRules.stream().map(MatchRule::deepClone).map(this.setOwner(owner)).map(x$0 -> (MatchRule)this.create((BaseEntity)x$0)).collect(Collectors.toList());
    }

    public void deleteCascade(S owner) {
        Preconditions.checkNotNull(owner);
        this.getMatchRules(owner).stream().forEach(x$0 -> this.delete((BaseEntity)x$0));
    }

    public String[] getColumns() {
        return TABLE_COLUMNS.stream().map(Enum::name).map(this::convertForeignKeyColumn).collect(Collectors.toList()).toArray(new String[0]);
    }

    private String convertForeignKeyColumn(String columnName) {
        return columnName.equals(TableColumn.owner_fk.name()) ? this.getForeignKeyColumn() : columnName;
    }

    public String getSequenceName() {
        return this.getTableName() + "_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        MatchRule matchRule = (MatchRule)baseEntity;
        preparedStatement.setString(TableColumn.dynamicparameters.index(), matchRule.getDynamicParametersAsJson());
        preparedStatement.setShort(TableColumn.exclusion.index(), matchRule.isExclusion() ? (short)1 : 0);
        preparedStatement.setLong(TableColumn.owner_fk.index(), matchRule.getOwnerId());
        preparedStatement.setString(TableColumn.operationtype.index(), matchRule.getOperationType());
        return this.assignFingerprint(preparedStatement, TableColumn.fingerprint.index(), new Object[]{matchRule.isExclusion() ? 1 : 0, matchRule.getOperationType(), matchRule.getDynamicParametersAsJson(), matchRule.getOwnerId()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        MatchRule matchRule = (MatchRule)baseEntity;
        matchRule.setDynamicParametersFromJson(resultSet.getString(TableColumn.dynamicparameters.name()));
        matchRule.setExclusion(resultSet.getShort(TableColumn.exclusion.name()) == 1);
        matchRule.setOperationType(resultSet.getString(TableColumn.operationtype.name()));
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getInt(TableColumn.exclusion.name()), resultSet.getString(TableColumn.operationtype.name()), resultSet.getString(TableColumn.dynamicparameters.name()), resultSet.getLong(this.getForeignKeyColumn())};
        }
        return null;
    }

    public T update(T entry) {
        return (T)((MatchRule)super.update(entry));
    }

    protected Function<T, T> setOwner(S owner) {
        return entity -> {
            this.setOwner(entity, owner);
            return entity;
        };
    }

    protected abstract void setOwner(T var1, S var2);

    protected abstract String getForeignKeyColumn();

    private static enum TableColumn {
        id,
        exclusion,
        operationtype,
        dynamicparameters,
        owner_fk,
        fingerprint,
        fingerprintversion,
        fingerprintkeygeneration;


        int index() {
            return this.ordinal();
        }
    }
}

