/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.limits;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LimitMatcher;
import com.ericsson.em.emc.hierarchies.limits.LimitMatchingParameters;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import org.joda.time.DateTime;

public final class ThresholdMatcher {
    private ThresholdMatcher() {
    }

    public static boolean isMatching(ThresholdConfiguration configuration, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        if (!configuration.within(dateTime)) {
            return false;
        }
        if (matchingParameters.shallMatchOnUnit() && !ThresholdMatcher.hasMatchingUnit(configuration, matchingParameters.getUnit())) {
            return false;
        }
        if (matchingParameters.shallMatchOnType() && !ThresholdMatcher.hasMatchingThresholdType(configuration, matchingParameters)) {
            return false;
        }
        return LimitMatcher.isMatching(configuration.getMatchRules(), matchingParameters);
    }

    private static boolean hasMatchingUnit(ThresholdConfiguration configuration, Unit unit) {
        return configuration.hasMatchingUnit(unit);
    }

    private static boolean hasMatchingThresholdType(ThresholdConfiguration configuration, LimitMatchingParameters matchingParameters) {
        return configuration.getThresholdType().equals(matchingParameters.getType());
    }
}

