/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.limits;

import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.CounterMatchRuleBuilder;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRuleBuilder;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdMatchRuleBuilder;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class LegacyLimitsConverter {
    public static final String CONVERTED_PROPERTY = "CONVERTED";

    private LegacyLimitsConverter() {
    }

    public static List<ModifierMatchRule> convertToModifierMatchRules(String modifierUnitType) {
        LinkedList<ModifierMatchRule> matchRules = Lists.newLinkedList();
        if (Strings.isNullOrEmpty(modifierUnitType)) {
            return matchRules;
        }
        for (String transferType : modifierUnitType.split(",")) {
            matchRules.add((ModifierMatchRule)new ModifierMatchRuleBuilder().transferType(transferType.trim()).property(CONVERTED_PROPERTY, Boolean.TRUE.toString()).get());
        }
        return matchRules;
    }

    public static List<CounterMatchRule> convertToCounterMatchRules(String unitType) {
        LinkedList<CounterMatchRule> matchRules = Lists.newLinkedList();
        if (Strings.isNullOrEmpty(unitType)) {
            return matchRules;
        }
        List transferTypes = Arrays.stream(unitType.split(",")).map(String::trim).sorted().collect(Collectors.toList());
        for (String transferType : transferTypes) {
            matchRules.add((CounterMatchRule)new CounterMatchRuleBuilder().transferType(transferType).property(CONVERTED_PROPERTY, Boolean.TRUE.toString()).get());
        }
        return matchRules;
    }

    public static List<ThresholdMatchRule> convertToThresholdMatchRules(String modifierUnitType) {
        LinkedList<ThresholdMatchRule> matchRules = Lists.newLinkedList();
        if (Strings.isNullOrEmpty(modifierUnitType)) {
            return matchRules;
        }
        for (String transferType : modifierUnitType.split(",")) {
            matchRules.add((ThresholdMatchRule)new ThresholdMatchRuleBuilder().transferType(transferType.trim()).property(CONVERTED_PROPERTY, Boolean.TRUE.toString()).get());
        }
        return matchRules;
    }

    public static CounterType extractCounterTypeFrom(String unitType) {
        return CounterConfiguration.NoCounterType.NONE;
    }
}

