/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.hierarchies.counters.Modifier;
import com.ericsson.em.emc.hierarchies.counters.ModifierResponse;
import com.ericsson.em.emc.hierarchies.counters.ModifierService;
import com.ericsson.em.emc.hierarchies.counters.PersonalLimitsManager;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfigurationBuilder;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;

@Singleton
public class PersonalLimitsManagerBean
implements PersonalLimitsManager {
    @EJB
    private CounterBalanceDAO counterBalanceDAO;
    @EJB
    private ModifierService modifierService;
    @EJB
    private PersonalModifierConfigurationDAO personalModifierConfigurationDAO;
    @EJB
    private IndividualCounterConfigurationDAO individualCounterConfigurationDAO;
    @EJB
    private ProfileReferenceDAO profileReferenceDAO;
    private final ConcurrentMap<String, Modifier> modifiers = new ConcurrentHashMap<String, Modifier>();

    @Override
    public PersonalModifierConfiguration find(CounterConfiguration counterConfiguration, ProfileReference profileReference) {
        PersonalModifierConfiguration result = this.personalModifierConfigurationDAO.find(counterConfiguration, profileReference);
        if (result != null) {
            result.setCounterConfiguration(counterConfiguration);
            result.setProfileReference(profileReference);
        }
        return result;
    }

    @Override
    public PersonalModifierConfiguration savePersonalLimit(CounterConfiguration counterConfiguration, ProfileReference profileReference, BigDecimal value) {
        if (!counterConfiguration.isPersonalizedLimitAllowed()) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PERSONAL_LIMIT_NOT_ALLOWED).create();
        }
        this.checkIfPersonalLimitIsLowerThanDefault(counterConfiguration, value);
        PersonalModifierConfiguration personalModifierConfiguration = this.find(counterConfiguration, profileReference);
        CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, DateTime.now());
        if (counterBalance != null) {
            counterBalance.setLimitPersonalized(true);
            this.counterBalanceDAO.update(counterBalance);
        }
        if (personalModifierConfiguration == null) {
            return this.createPersonalLimit(counterConfiguration, profileReference, value);
        }
        return this.updatePersonalLimit(personalModifierConfiguration, value);
    }

    @Override
    public PersonalModifierConfiguration delete(CounterConfiguration counterConfiguration, ProfileReference profileReference) {
        PersonalModifierConfiguration configuration = this.personalModifierConfigurationDAO.find(counterConfiguration, profileReference);
        if (configuration == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PERSONAL_LIMIT_DOES_NOT_EXIST).add("counterConfigurationId", counterConfiguration.getId()).add("profileReferenceId", profileReference.getProfileReferenceId()).create();
        }
        this.personalModifierConfigurationDAO.delete(configuration);
        CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, DateTime.now());
        if (counterBalance != null) {
            counterBalance.setLimitPersonalized(false);
            this.counterBalanceDAO.update(counterBalance);
        }
        return configuration;
    }

    @Override
    public Optional<ModifierResponse> executePersonalModifier(ProfileReference profileReference, CounterConfiguration counterConfiguration, PersonalModifierConfiguration personalModifierConfiguration, BigDecimal startValue, BigDecimal endValue, BigDecimal debitAmount) {
        if (personalModifierConfiguration == null) {
            return Optional.empty();
        }
        Modifier modifier = (Modifier)this.modifiers.get(personalModifierConfiguration.getClassName());
        if (modifier == null) {
            try {
                modifier = (Modifier)ClassLoader.getSystemClassLoader().loadClass(personalModifierConfiguration.getClassName()).newInstance();
                this.modifiers.put(personalModifierConfiguration.getClassName(), modifier);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error while loading modifier: %s", personalModifierConfiguration.getClassName()), e);
            }
        }
        ModifierResponse modifierResponse = modifier.execute(personalModifierConfiguration, profileReference, counterConfiguration, startValue, endValue, debitAmount);
        modifierResponse.setModifierConfiguration(personalModifierConfiguration);
        modifierResponse.setCounterConfiguration(counterConfiguration);
        modifierResponse.setModifier(modifier);
        modifierResponse.setCurrentCounterValue(endValue);
        return Optional.of(modifierResponse);
    }

    @Override
    public void deleteByCounterConfiguration(CounterConfiguration counterConfiguration) {
        this.personalModifierConfigurationDAO.deleteByCounterConfiguration(counterConfiguration);
    }

    private PersonalModifierConfiguration createPersonalLimit(CounterConfiguration counterConfiguration, ProfileReference profileReference, BigDecimal value) {
        return this.personalModifierConfigurationDAO.create((PersonalModifierConfiguration)new PersonalModifierConfigurationBuilder().counterConfiguration(counterConfiguration).profileReference(profileReference).startValue(value).endValue(BigDecimal.valueOf(999999L)).data(this.getExceptionType(counterConfiguration)).className("com.ericsson.em.emm.authorization.AuthorizationFailedModifier").get());
    }

    private PersonalModifierConfiguration updatePersonalLimit(PersonalModifierConfiguration personalModifierConfiguration, BigDecimal value) {
        personalModifierConfiguration.setStartValue(value);
        return this.personalModifierConfigurationDAO.update(personalModifierConfiguration);
    }

    @Override
    public CounterConfiguration getCounterConfiguration(PersonalModifierConfiguration personalModifierConfiguration) {
        if (personalModifierConfiguration.getCounterConfiguration() == null) {
            return this.individualCounterConfigurationDAO.find(personalModifierConfiguration.getCounterConfigurationId());
        }
        return personalModifierConfiguration.getCounterConfiguration();
    }

    @Override
    public ProfileReference getProfileReference(PersonalModifierConfiguration personalModifierConfiguration) {
        if (personalModifierConfiguration.getProfileReference() == null) {
            return this.profileReferenceDAO.find(personalModifierConfiguration.getProfileReferenceId());
        }
        return personalModifierConfiguration.getProfileReference();
    }

    private void checkIfPersonalLimitIsLowerThanDefault(CounterConfiguration counterConfiguration, BigDecimal value) {
        List<ModifierConfiguration> modifierConfigurationList = counterConfiguration.getModifierConfigurations();
        if (modifierConfigurationList.size() == 1 && modifierConfigurationList.get(0).getStartValue().compareTo(value) < 1) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PERSONAL_LIMIT_TOO_HIGH).create();
        }
    }

    private String getExceptionType(CounterConfiguration counterConfiguration) {
        switch (counterConfiguration.getCounterType().getName()) {
            case "AMOUNT_FEE": 
            case "FEE": {
                return "AUTHORIZATION_PERSONAL_MAX_TRANSFER_AMOUNT_FEE";
            }
            case "ACCOUNT_THROUGHPUT": {
                return "AUTHORIZATION_PERSONAL_MAX_TRANSFER_ACCOUNT_THROUGHPUT";
            }
            case "TIMES": {
                return "AUTHORIZATION_PERSONAL_MAX_TRANSFER_TIMES";
            }
        }
        return "AUTHORIZATION_PERSONAL_MAX_TRANSFER_AMOUNT";
    }
}

