/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.hierarchies.SharedCounterImportManager;
import com.ericsson.em.emc.hierarchies.counters.PermissiveSharedCounterImportHandler;
import com.ericsson.em.emc.hierarchies.counters.SharedCounterImportHandler;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelation;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterOverride;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.transaction.TransactionManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class PermissiveSharedCounterImportHandlerBean
implements PermissiveSharedCounterImportHandler {
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private ModifierConfigurationDAO modifierConfigurationDAO;
    @EJB
    private SharedCounterImportManager sharedCounterImportManager;
    @EJB
    private ProfileCounterRelationDAO profileCounterRelationDAO;
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @Resource
    private TransactionManager transactionManager;
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    public void postConstruct() {
        this.sharedCounterImportManager.registerPermissiveSharedCounterImportHandler((SharedCounterImportHandler)this.applicationContext.getThis());
    }

    @Override
    public void importSharedCounter(SharedCounterConfiguration sharedCounterConfiguration, String name) {
        SharedCounterConfiguration createdSharedCounterConfiguration = this.sharedCounterConfigurationDAO.create(sharedCounterConfiguration);
        Optional.ofNullable(sharedCounterConfiguration.getModifierConfigurations()).ifPresent(modifierConfigurations -> modifierConfigurations.forEach(modifierConfiguration -> this.modifierConfigurationDAO.create((ModifierConfiguration)modifierConfiguration, createdSharedCounterConfiguration)));
    }

    @Override
    public void updateSharedCounter(long id, SharedCounterConfiguration sharedCounterConfiguration, String name) {
        SharedCounterConfiguration existingSharedCounterConfiguration = this.sharedCounterConfigurationDAO.findByName(name);
        if (existingSharedCounterConfiguration == null) {
            throw new IllegalArgumentException("Couldn't find shared counter config " + name);
        }
        String nameFromSerializedData = sharedCounterConfiguration.getName();
        if (nameFromSerializedData == null || nameFromSerializedData.isEmpty()) {
            sharedCounterConfiguration.setName(name);
        }
        Collection existingModifierConfigurations = Optional.ofNullable(this.modifierConfigurationDAO.findModifierConfigurations(existingSharedCounterConfiguration)).orElse(Collections.emptyList());
        existingSharedCounterConfiguration.copyFrom(sharedCounterConfiguration);
        SharedCounterConfiguration updatedSharedCounterConfiguration = this.sharedCounterConfigurationDAO.update(existingSharedCounterConfiguration);
        Collection profileCounterRelations = Optional.ofNullable(this.profileCounterRelationDAO.findRelationByCounterName(name)).orElse(Collections.emptyList());
        if (!name.equals(sharedCounterConfiguration.getName())) {
            this.updateProfileCounterRelationsWithNewName(sharedCounterConfiguration.getName(), profileCounterRelations);
        }
        this.updateModifierConfigurations(existingModifierConfigurations, updatedSharedCounterConfiguration);
        this.updateProfileServices(name, updatedSharedCounterConfiguration, profileCounterRelations);
    }

    private void updateProfileServices(String originalName, SharedCounterConfiguration updatedSharedCounterConfiguration, Collection<ProfileCounterRelation> profileCounterRelations) {
        Collection profileServiceIdsToUpdate = profileCounterRelations.stream().map(ProfileCounterRelation::getProfileServiceId).collect(Collectors.toList());
        Collection<ProfileService> updatedProfileServices = this.triggerServiceChangedListeners(profileServiceIdsToUpdate);
        this.transactionManager.afterCompletion(t -> updatedProfileServices.forEach(profileService -> {
            profileService.removeSharedCounterConfiguration(originalName);
            profileService.removeSharedCounterOverride(originalName);
            profileService.addSharedCounterConfiguration(updatedSharedCounterConfiguration);
            BigDecimal limit = profileCounterRelations.stream().filter(it -> it.getProfileServiceId() == profileService.getId().longValue()).findFirst().map(ProfileCounterRelation::getCounterConfigurationLimit).orElse(null);
            profileService.addSharedCounterOverride(SharedCounterOverride.newBuilder().name(updatedSharedCounterConfiguration.getName()).limit(limit).build());
        }));
    }

    private Collection<ProfileService> triggerServiceChangedListeners(Collection<Long> profileCounterRelationsIds) {
        LinkedList<ProfileService> updatedProfileServices = new LinkedList<ProfileService>();
        List<Profile> allProfiles = this.profileDAO.findAll();
        allProfiles.stream().map(Profile::getServices).forEach(profileServices -> profileServices.stream().filter(profileService -> profileCounterRelationsIds.contains(profileService.getId())).findFirst().ifPresent(profileService -> {
            this.profileServiceDAO.update((ProfileService)profileService);
            updatedProfileServices.add((ProfileService)profileService);
        }));
        return updatedProfileServices;
    }

    private void updateModifierConfigurations(Collection<ModifierConfiguration> existingModifierConfigurations, SharedCounterConfiguration updatedSharedCounterConfiguration) {
        existingModifierConfigurations.forEach(modifierConfiguration -> this.modifierConfigurationDAO.delete((ModifierConfiguration)modifierConfiguration));
        this.createModifierConfigurations(updatedSharedCounterConfiguration);
    }

    private void updateProfileCounterRelationsWithNewName(String newName, Collection<ProfileCounterRelation> profileCounterRelations) {
        profileCounterRelations.forEach(profileCounterRelation -> {
            profileCounterRelation.setCounterConfigurationName(newName);
            this.profileCounterRelationDAO.update((ProfileCounterRelation)((Object)profileCounterRelation));
        });
    }

    private void createModifierConfigurations(SharedCounterConfiguration sharedCounterConfiguration) {
        Optional.ofNullable(sharedCounterConfiguration.getModifierConfigurations()).ifPresent(modifierConfigurations -> modifierConfigurations.forEach(modifierConfiguration -> this.modifierConfigurationDAO.create((ModifierConfiguration)modifierConfiguration, sharedCounterConfiguration)));
    }
}

