/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.hierarchies.counters.Modifier;
import com.ericsson.em.emc.hierarchies.counters.ModifierResponse;
import com.ericsson.em.emc.hierarchies.counters.ModifierService;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class ModifierServiceBean
implements ModifierService {
    private final Map<Long, Modifier> modifiers = new ConcurrentHashMap<Long, Modifier>();

    @Override
    public ModifierResponse executeModifier(ModifierConfiguration modifierConfiguration, ProfileReference profileReference, CounterConfiguration counterConfiguration, BigDecimal startValue, BigDecimal endValue, BigDecimal debitAmount) {
        Modifier modifier = this.modifiers.get(modifierConfiguration.getId());
        if (modifier == null) {
            try {
                modifier = (Modifier)ClassLoader.getSystemClassLoader().loadClass(modifierConfiguration.getClassName()).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error while loading modifier: %s", modifierConfiguration.getClassName()), e);
            }
            this.modifiers.put(modifierConfiguration.getId(), modifier);
        }
        ModifierResponse response = modifier.execute(modifierConfiguration, profileReference, counterConfiguration, startValue, endValue, debitAmount);
        response.setCounterConfiguration(counterConfiguration);
        response.setModifierConfiguration(modifierConfiguration);
        response.setModifier(modifier);
        response.setCurrentCounterValue(endValue);
        return response;
    }
}

