/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.ProfileAdminManager;
import com.ericsson.em.emc.hierarchies.ProfileExportManager;
import com.ericsson.em.emc.hierarchies.ProfileImportManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogContext;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogger;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.google.common.collect.Sets;
import jakarta.annotation.Resource;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileAdminManagerBean
implements ProfileAdminManager {
    @EJB
    private ProfileDAO profileDAO;
    @Resource
    private StatisticsService statisticsService;
    @EJB
    private ProfileImportManager profileImportManager;
    @EJB
    private ProfileExportManager profileExportManager;
    @EJB
    private HierarchyManager hierarchyManager;
    private static final Logger logger = LoggerFactory.getLogger(ProfileAdminManagerBean.class);
    private static final Set<String> DEFAULT_FLAGS = Collections.singleton("permissive-mode");

    private RuntimeException logAndPropagate(RuntimeException exception) {
        logger.debug("Profile import failed", exception);
        return exception;
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void clone(String profileName, String newProfileName) {
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "clone", StatisticsService.MeasurementType.INTERNAL);
        try {
            String exportedProfile = this.profileExportManager.exportProfile(profileName);
            this.profileImportManager.cloneProfile(newProfileName, exportedProfile, DEFAULT_FLAGS);
        }
        catch (RuntimeException e) {
            measurement.setError();
            throw this.logAndPropagate(e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    @Deprecated
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void importProfile(String newProfileName, String serializedData) {
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
        try {
            this.profileImportManager.importProfile(newProfileName, serializedData, DEFAULT_FLAGS);
        }
        catch (RuntimeException e) {
            measurement.setError();
            throw this.logAndPropagate(e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    @Deprecated
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void importProfile(String newProfileName, String serializedData, Set<String> flags) {
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
        try {
            HashSet<String> flagsWithDefaultFlags = Sets.newHashSet(flags);
            flagsWithDefaultFlags.addAll(DEFAULT_FLAGS);
            this.profileImportManager.importProfile(newProfileName, serializedData, flagsWithDefaultFlags);
        }
        catch (RuntimeException e) {
            measurement.setError();
            throw this.logAndPropagate(e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    @Deprecated
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void importProfile(String newProfileName, String serializedData, String profileType) {
        if (profileType == null) {
            this.importProfile(newProfileName, serializedData);
        } else {
            Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
            try {
                this.profileImportManager.importProfile(newProfileName, serializedData, profileType, DEFAULT_FLAGS);
            }
            catch (RuntimeException e) {
                measurement.setError();
                throw this.logAndPropagate(e);
            }
            finally {
                this.statisticsService.stopMeasurement(measurement);
            }
        }
    }

    @Override
    @Deprecated
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void importProfile(String newProfileName, String serializedData, String profileType, Set<String> flags) {
        HashSet<String> flagsWithDefaultFlags = Sets.newHashSet(flags);
        flagsWithDefaultFlags.addAll(DEFAULT_FLAGS);
        if (profileType == null) {
            this.importProfile(newProfileName, serializedData, flagsWithDefaultFlags);
        } else {
            Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
            try {
                this.profileImportManager.importProfile(newProfileName, serializedData, profileType, flagsWithDefaultFlags);
            }
            catch (RuntimeException e) {
                measurement.setError();
                throw this.logAndPropagate(e);
            }
            finally {
                this.statisticsService.stopMeasurement(measurement);
            }
        }
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void validateAndImportProfile(String newProfileName, String serializedData, String profileType) {
        if (profileType == null) {
            this.importProfile(newProfileName, serializedData);
        } else {
            Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
            try {
                this.profileImportManager.importProfile(newProfileName, serializedData, profileType, Collections.emptySet());
            }
            catch (RuntimeException e) {
                measurement.setError();
                throw this.logAndPropagate(e);
            }
            finally {
                this.statisticsService.stopMeasurement(measurement);
            }
        }
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="ImportProfile", flags={"forcelog"})
    public void validateAndImportProfile(String newProfileName, String serializedData, Set<String> flags) {
        this.auditTrailLog(flags);
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "import", StatisticsService.MeasurementType.INTERNAL);
        try {
            this.profileImportManager.importProfile(newProfileName, serializedData, flags);
        }
        catch (RuntimeException e) {
            measurement.setError();
            throw this.logAndPropagate(e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public String exportProfile(String profileName) {
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "export", StatisticsService.MeasurementType.INTERNAL);
        try {
            String string = this.profileExportManager.exportProfile(profileName);
            return string;
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public List<String> getProfileNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Profile profile : this.profileDAO.findAll()) {
            String profileType = this.hierarchyManager.findProperty(profile, "General", "Profile Type");
            result.add(profileType + ";" + profile.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="UpdateProfile", flags={"forcelog"})
    public void updateProfile(String existingProfileName, String serializedData, Set<String> flags) {
        this.auditTrailLog(flags);
        Measurement measurement = this.statisticsService.startMeasurment("ProfileAdminManager", "update", StatisticsService.MeasurementType.INTERNAL);
        try {
            this.profileImportManager.updateProfile(existingProfileName, serializedData, flags);
        }
        catch (RuntimeException e) {
            measurement.setError();
            throw this.logAndPropagate(e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
    }

    private void auditTrailLog(Set<String> flags) {
        AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
        if (auditTrailLogger.isLogEnable()) {
            auditTrailLogger.log("PermissiveMode", (Object)flags.contains("permissive-mode"));
        }
    }
}

