/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.feature.persistence;

import com.ericsson.em.emc.feature.persistence.ActiveFeatureDAO;
import com.ericsson.em.emc.feature.persistence.FeatureEntity;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoFingerprintValidatableDAO;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.feature.Feature;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

@Singleton
@Validatable
@CryptoKeys(keyAliases={"emm.activefeature.S"})
public class ActiveFeatureDAOBean
extends CryptoExtendedBaseEntityDAOBean<FeatureEntity>
implements CryptoFingerprintValidatableDAO<FeatureEntity>,
ActiveFeatureDAO {
    private static final int FINGERPRINT_VERSION = 1;
    public static final String FINGERPRINT_KEY_ALIAS = "emm.activefeature.S";
    private static final String TABLE_NAME = "emm$activefeature";
    private static final String SEQUENCE_NAME = "emm$activefeature_seq";
    private static final String COL_ID = "id";
    private static final String COL_NAME = "name";
    private static final String[] COLUMNS = new String[]{"id", "name", "fingerprint", "fingerprintversion", "fingerprintkeygeneration"};

    @Override
    public FeatureEntity create(FeatureEntity feature) {
        return (FeatureEntity)super.create((BaseEntity)feature);
    }

    @Override
    public void delete(FeatureEntity feature) {
        String query = "DELETE FROM " + TABLE_NAME + " WHERE " + COL_NAME + " = ?";
        super.delete(query, new Object[]{feature.getName()});
    }

    @Override
    public FeatureEntity find(Feature feature) {
        String query = this.getSelectStatement() + " WHERE " + COL_NAME + " = ?";
        return (FeatureEntity)super.find(query, new Object[]{feature.getName()});
    }

    @Override
    public FeatureEntity find(FeatureEntity feature) {
        String query = this.getSelectStatement() + " WHERE " + COL_NAME + " = ?";
        return (FeatureEntity)super.find(query, new Object[]{feature.getName()});
    }

    @Override
    public List<FeatureEntity> findAll() {
        return super.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    protected String getEntitySimpleName() {
        return FeatureEntity.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY_ALIAS;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return false;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        FeatureEntity entity = (FeatureEntity)baseEntity;
        entity.setName(resultSet.getString(COL_NAME));
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        FeatureEntity entity = (FeatureEntity)baseEntity;
        int i = 1;
        preparedStatement.setString(i++, entity.getName());
        return this.assignFingerprint(preparedStatement, i, new Object[]{entity.getName()});
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getString(COL_NAME)};
        }
        return null;
    }

    protected FeatureEntity createManagedEntity() {
        return new FeatureEntity();
    }
}

