/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.csv;

import com.ericsson.em.emc.csv.CSVCodecAdaptor;
import com.ericsson.em.emc.csv.CSVCodecException;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;

public class MoneyAdaptor
implements CSVCodecAdaptor<Money> {
    private static final String EMPTY_STR = "";

    @Override
    public Money decode(String data) throws CSVCodecException {
        if (data == null) {
            return null;
        }
        int index = data.indexOf(32);
        if (index != -1) {
            String amount = data.substring(0, index).trim();
            String currency = data.substring(index).trim();
            return EMPTY_STR.equals(data) ? null : Money.valueOf(amount, Currency.getInstance(currency));
        }
        throw new CSVCodecException("Failed to decode Money, Reason: unknown Money CSV format");
    }

    @Override
    public String encode(Money data) throws CSVCodecException {
        return data != null ? data.toString() : EMPTY_STR;
    }
}

