/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.csv;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.csv.CSVCodec;
import com.ericsson.em.emc.csv.CSVCodecFactory;
import com.ericsson.em.emc.csv.CSVCodecInfo;
import com.ericsson.em.emc.csv.CsvDetails;
import com.ericsson.em.emc.csv.CsvFileInfo;
import com.ericsson.em.emc.csv.HttpMultipartCsvDataExporter;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpMultipartCsvDataExporterBean
implements HttpMultipartCsvDataExporter {
    private static final Logger logger = LoggerFactory.getLogger(HttpMultipartCsvDataExporterBean.class);
    private static final String ENCAPSULATION_BOUNDARY = "--";
    private static final Duration MAXIMUM_TIME_TO_WAIT_FOR_CSV_WRITE = Duration.ofHours(1L);
    private static final char CSV_DELIMITER = ',';
    @Resource
    private TransactionManager transactionManager;

    @Override
    public void export(OutputStream outputStreamToWriteTo, CsvFileInfo csvFileInfo, List<CsvDetails> csvDetails, String multiPartBoundaryValue) {
        this.export(outputStreamToWriteTo, csvFileInfo, csvDetails, multiPartBoundaryValue, HttpMultipartCsvDataExporter.ExportFormat.ZIP_COMPRESSED_CSV);
    }

    @Override
    public void export(OutputStream outputStreamToWriteTo, CsvFileInfo csvFileInfo, List<CsvDetails> csvDetails, String multiPartBoundaryValue, HttpMultipartCsvDataExporter.ExportFormat exportFormat) {
        if (csvDetails.isEmpty()) {
            logger.debug("Nothing available to export");
            throw new UserExceptionBuilder(CoreUserErrorCode.NOTHING_TO_EXPORT).create();
        }
        this.tryToWriteDetailsToStream(outputStreamToWriteTo, csvFileInfo, csvDetails, multiPartBoundaryValue, exportFormat);
    }

    private void tryToWriteDetailsToStream(OutputStream outputStreamToWriteTo, CsvFileInfo csvFileInfo, List<CsvDetails> csvDetails, String boundaryValue, HttpMultipartCsvDataExporter.ExportFormat exportFormat) {
        try {
            logger.trace("Export start");
            this.writeDetailsToStreamInNewTransactionScope(outputStreamToWriteTo, csvFileInfo, csvDetails, boundaryValue, exportFormat);
        }
        catch (Exception e) {
            logger.trace("", e);
            throw new UserExceptionBuilder(CoreUserErrorCode.FAILED_TO_EXPORT).create();
        }
        finally {
            logger.trace("Export end");
        }
    }

    private void writeDetailsToStreamInNewTransactionScope(OutputStream outputStreamToWriteTo, CsvFileInfo csvFileInfo, List<CsvDetails> csvDetails, String boundaryValue, HttpMultipartCsvDataExporter.ExportFormat exportFormat) {
        this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithTimeout(MAXIMUM_TIME_TO_WAIT_FOR_CSV_WRITE.toHours(), TimeUnit.HOURS), () -> HttpMultipartCsvDataExporterBean.writeDetailsToStream(outputStreamToWriteTo, csvFileInfo, csvDetails, boundaryValue, exportFormat));
    }

    private static Void writeDetailsToStream(OutputStream outputStreamToWriteTo, CsvFileInfo csvFileInfo, List<CsvDetails> csvDetails, String boundaryValue, HttpMultipartCsvDataExporter.ExportFormat exportFormat) throws IOException {
        CSVCodec csvCodec = CSVCodecFactory.create(',');
        CSVCodecInfo csvCodecInfo = csvDetails.get(0).getCsvCodecInfo();
        String csvFileName = HttpMultipartCsvDataExporterBean.generateFileName(csvCodecInfo.getFilename(), csvFileInfo, "csv");
        outputStreamToWriteTo.write(HttpMultipartCsvDataExporterBean.getStartingHttpMultipartEncapsulation(boundaryValue).getBytes());
        if (exportFormat == HttpMultipartCsvDataExporter.ExportFormat.ZIP_COMPRESSED_CSV) {
            String zipFileName = HttpMultipartCsvDataExporterBean.generateFileName(csvCodecInfo.getFilename(), csvFileInfo, "zip");
            outputStreamToWriteTo.write(HttpMultipartCsvDataExporterBean.getHttpHeaderData(zipFileName, exportFormat).getBytes());
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStreamToWriteTo);){
                zipOutputStream.putNextEntry(new ZipEntry(csvFileName));
                zipOutputStream.write(csvCodec.getEncodedCsvHeader(csvCodecInfo).getBytes());
                for (CsvDetails csvDetail : csvDetails) {
                    zipOutputStream.write(csvCodec.encode(csvDetail, csvCodecInfo).getBytes());
                }
                zipOutputStream.closeEntry();
            }
        } else if (exportFormat == HttpMultipartCsvDataExporter.ExportFormat.CSV) {
            outputStreamToWriteTo.write(HttpMultipartCsvDataExporterBean.getHttpHeaderData(csvFileName, exportFormat).getBytes());
            outputStreamToWriteTo.write(csvCodec.getEncodedCsvHeader(csvCodecInfo).getBytes());
            for (CsvDetails csvDetail : csvDetails) {
                outputStreamToWriteTo.write(csvCodec.encode(csvDetail, csvCodecInfo).getBytes());
            }
        } else {
            throw new IllegalArgumentException("Unsupported format");
        }
        outputStreamToWriteTo.write(System.lineSeparator().getBytes());
        outputStreamToWriteTo.write(HttpMultipartCsvDataExporterBean.getEndingHttpMultipartEncapsulation(boundaryValue).getBytes());
        return null;
    }

    @VisibleForTesting
    static String generateFileName(String format, CsvFileInfo csvFileInfo, String fileExtension) {
        return csvFileInfo.generateFileName(format, fileExtension);
    }

    @VisibleForTesting
    static String getStartingHttpMultipartEncapsulation(String boundaryValue) {
        return ENCAPSULATION_BOUNDARY + boundaryValue + System.lineSeparator();
    }

    @VisibleForTesting
    static String getHttpHeaderData(String fileName, HttpMultipartCsvDataExporter.ExportFormat exportFormat) {
        return "Content-Type: " + HttpMultipartCsvDataExporterBean.getContentType(exportFormat) + System.lineSeparator() + "Content-Disposition: attachment; filename=\"" + fileName + "\"" + System.lineSeparator() + System.lineSeparator();
    }

    @VisibleForTesting
    static String getEndingHttpMultipartEncapsulation(String boundaryValue) {
        return ENCAPSULATION_BOUNDARY + boundaryValue + ENCAPSULATION_BOUNDARY + System.lineSeparator();
    }

    static String getContentType(HttpMultipartCsvDataExporter.ExportFormat exportFormat) {
        if (exportFormat == HttpMultipartCsvDataExporter.ExportFormat.ZIP_COMPRESSED_CSV) {
            return "application/zip";
        }
        if (exportFormat == HttpMultipartCsvDataExporter.ExportFormat.CSV) {
            return "text/csv";
        }
        throw new IllegalArgumentException("Unsupported format");
    }
}

