/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialHistoryDAO;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.lwac.application.DatabaseType;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.security.HashVersion;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.credentialhistory.S"})
public class CredentialHistoryDAOBean
extends CryptoExtendedBaseEntityDAOBean<CredentialHistory>
implements CredentialHistoryDAO {
    @Resource
    private ApplicationContext applicationContext;
    private static final String[] COLUMNS = new String[]{"id", "fk_credentialownerreference", "fk_credentialtype", "hashedpassword", "hashversion", "changedate", "fingerprint", "fingerprintversion", "fingerprintkeygeneration", "version"};
    private static final int CREDENTIAL_HISTORY_CURRENT_FINGERPRINT_VERSION = 1;
    static final String CREDENTIAL_HISTORY_FINGERPRINT_KEY = "emm.credentialhistory.S";

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        CredentialHistory credentialHistory = (CredentialHistory)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, credentialHistory.getCredentialOwnerReferenceId());
        preparedStatement.setLong(i++, credentialHistory.getCredentialTypeId());
        preparedStatement.setBytes(i++, credentialHistory.getHashedPassword());
        preparedStatement.setInt(i++, credentialHistory.getHashVersion().toInt());
        preparedStatement.setObject(i++, credentialHistory.getChangeDate());
        i = this.assignFingerprint(preparedStatement, i, new Object[]{credentialHistory.getCredentialOwnerReferenceId(), credentialHistory.getCredentialTypeId(), credentialHistory.getHashedPassword(), credentialHistory.getHashVersion().toInt(), credentialHistory.getChangeDate()});
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CredentialHistory credentialHistory = (CredentialHistory)baseEntity;
        credentialHistory.setCredentialOwnerReferenceId(resultSet.getLong("fk_credentialownerreference"));
        credentialHistory.setCredentialTypeId(resultSet.getLong("fk_credentialtype"));
        credentialHistory.setHashedPassword(resultSet.getBytes("hashedpassword"));
        credentialHistory.setHashVersion(HashVersion.fromInt(resultSet.getInt("hashversion")));
        credentialHistory.setChangeDate(resultSet.getTimestamp("changedate"));
        credentialHistory.setVersion(resultSet.getLong("version"));
    }

    protected CredentialHistory createManagedEntity() {
        return new CredentialHistory();
    }

    @Override
    public CredentialHistory find(long id) {
        return (CredentialHistory)super.find(id);
    }

    @Override
    public List<CredentialHistory> findByCredentialOwnerReference(CredentialOwnerReference credentialOwnerReference) {
        return this.findMultiple(this.getSelectStatement() + " where fk_credentialownerreference = ?", new Object[]{credentialOwnerReference.getId()});
    }

    @Override
    public CredentialHistory create(CredentialHistory credentialHistory) {
        return (CredentialHistory)super.create((BaseEntity)credentialHistory);
    }

    public CredentialHistory update(CredentialHistory CredentialHistory2) {
        return (CredentialHistory)super.updateWithVersionCheck((BaseEntity)CredentialHistory2);
    }

    @Override
    public void delete(CredentialHistory credentialHistory) {
        super.deleteWithVersionCheck((BaseEntity)credentialHistory);
    }

    @Override
    public List<CredentialHistory> findLatestByCredentialOwnerAndCredentialType(CredentialOwner credentialOwner, CredentialType credentialType, int numOfEntries) {
        StringBuilder statement = new StringBuilder(256);
        statement.append("select * from (").append(this.getSelectStatement()).append(" where fk_credentialownerreference = ? and fk_credentialtype = ? order by changedate desc) c ");
        statement.append(switch (this.applicationContext.getDatabaseType()) {
            case DatabaseType.NUODB, DatabaseType.MYSQL -> "limit ?";
            default -> "where rownum <= ?";
        });
        return this.findMultiple(statement.toString(), new Object[]{credentialOwner.getCredentialOwnerReference().getId(), credentialType.getId(), numOfEntries});
    }

    @Override
    public CredentialHistory findOldestByCredentialOwnerReferenceId(long credentialOwnerReferenceId) {
        return (CredentialHistory)this.find(this.getSelectStatement() + " where fk_credentialownerreference = ? order by changeDate", new Object[]{credentialOwnerReferenceId});
    }

    protected String getEntitySimpleName() {
        return CredentialHistory.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return CREDENTIAL_HISTORY_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_credentialtype"), resultSet.getBytes("hashedpassword"), resultSet.getInt("hashversion"), resultSet.getTimestamp("changedate")};
        }
        return null;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return "emm$credentialhistory_seq";
    }

    public String getTableName() {
        return "emm$credentialhistory";
    }

    public boolean isUpdatable() {
        return true;
    }

    public boolean isVersionable() {
        return true;
    }
}

