/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.CredentialStatus;
import com.ericsson.em.emc.credential.exception.CredentialErrorCode;
import com.ericsson.em.privacy.PersonalData;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.crypto.util.ByteArrays;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.ExtendedBaseEntityDAOBean;
import com.ericsson.lwac.persistence.Versionable;
import com.ericsson.lwac.security.HashVersion;
import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.DateTime;

public class Credential
extends BaseEntity
implements Versionable {
    private static final long serialVersionUID = 7394761923814389902L;
    private Long credentialOwnerReferenceId = null;
    private Long credentialTypeId = null;
    @PersonalData(type={PersonalData.PersonalDataType.PASSWORD})
    private byte[] hashedCredential = null;
    private Timestamp created = ExtendedBaseEntityDAOBean.getTimestamp((long)System.currentTimeMillis());
    private CredentialStatus status = CredentialStatus.ACTIVE;
    private DateTime loginTimestamp;
    private DateTime lastLoginTimestamp;
    private Integer failedLogins = 0;
    private Integer lastFailedLogins = 0;
    private DateTime lastFailedLoginTimestamp;
    private DateTime lastResetAttempt;
    private Integer keyGeneration = 0;
    private HashVersion hashVersion;
    private DateTime suspendedUntil;
    private long version = 1L;
    private transient int fingerPrintVersion;

    public Long getCredentialOwnerReferenceId() {
        return this.credentialOwnerReferenceId;
    }

    public void setCredentialOwnerReferenceId(Long credentialOwnerReferenceId) {
        this.credentialOwnerReferenceId = credentialOwnerReferenceId;
    }

    public Long getCredentialTypeId() {
        return this.credentialTypeId;
    }

    public void setCredentialTypeId(Long credentialTypeId) {
        this.credentialTypeId = credentialTypeId;
    }

    public byte[] getHashedCredential() {
        return ByteArrays.safeCopy((byte[])this.hashedCredential);
    }

    public void setHashedCredential(byte[] hashedCredential) {
        this.hashedCredential = ByteArrays.safeCopy((byte[])hashedCredential);
    }

    public Timestamp getCreated() {
        return ExtendedBaseEntityDAOBean.getTimestamp((Date)this.created);
    }

    public void setCreated(Timestamp created) {
        this.created = ExtendedBaseEntityDAOBean.getTimestamp((Date)created);
    }

    public CredentialStatus getStatus() {
        return this.status;
    }

    public void setStatus(CredentialStatus status) {
        this.status = status;
    }

    public HashVersion getHashVersion() {
        return this.hashVersion;
    }

    public void setHashVersion(HashVersion hashVersion) {
        this.hashVersion = hashVersion;
    }

    public String toString() {
        return "com.ericsson.em.emc.credential.persistence.Credential[id=" + this.mId + "]";
    }

    public DateTime getLoginTimestamp() {
        return this.loginTimestamp;
    }

    public void setLoginTimestamp(DateTime loginTimestamp) {
        this.loginTimestamp = loginTimestamp;
    }

    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public Integer getLastFailedLogins() {
        return this.lastFailedLogins;
    }

    public void setLastFailedLogins(Integer lastFailedLogins) {
        this.lastFailedLogins = lastFailedLogins;
    }

    public DateTime getLastFailedLoginTimestamp() {
        return this.lastFailedLoginTimestamp;
    }

    public void setLastFailedLoginTimestamp(DateTime lastFailedLoginTimestamp) {
        this.lastFailedLoginTimestamp = lastFailedLoginTimestamp;
    }

    public DateTime getLastLoginTimestamp() {
        return this.lastLoginTimestamp;
    }

    public void setLastLoginTimestamp(DateTime loginTimeStamp) {
        this.lastLoginTimestamp = loginTimeStamp;
    }

    public Integer getKeyGeneration() {
        return this.keyGeneration;
    }

    public void setKeyGeneration(Integer generation) {
        this.keyGeneration = generation;
    }

    public void setSuspendedUntil(DateTime until) {
        this.suspendedUntil = until;
    }

    public DateTime getSuspendedUntil() {
        return this.suspendedUntil;
    }

    public int getFingerPrintVersion() {
        return this.fingerPrintVersion;
    }

    public void setFingerPrintVersion(int fingerPrintVersion) {
        this.fingerPrintVersion = fingerPrintVersion;
    }

    public DateTime getLastResetAttempt() {
        return this.lastResetAttempt;
    }

    public void setLastResetAttempt(DateTime lastResetAttempt) {
        this.lastResetAttempt = lastResetAttempt;
    }

    protected void validate() {
        if (this.credentialOwnerReferenceId == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_OWNER_REFERENCE.getMessage());
        }
        if (this.credentialTypeId == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_TYPE.getMessage());
        }
        if (this.hashedCredential == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_HASHED_PASSWORD.getMessage());
        }
        if (this.hashedCredential.length == 0) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_EMPTY_HASHED_PASSWORD.getMessage());
        }
        if (this.created == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREATION_DATE.getMessage());
        }
        if (this.status == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_STATUS.getMessage());
        }
        if (this.hashVersion == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_HASH_VERSION.getMessage());
        }
        if (this.failedLogins == null || this.lastFailedLogins == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_FAILED_LOGINS.getMessage());
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }
}

