/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.credential.CredentialManager;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.CredentialResetHandler;
import com.ericsson.em.emc.credential.CredentialStatus;
import com.ericsson.em.emc.credential.CredentialTypeProvider;
import com.ericsson.em.emc.credential.exception.CredentialErrorCode;
import com.ericsson.em.emc.credential.exception.CredentialException;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialDAO;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialHistoryDAO;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.credential.persistence.CredentialTypeDAO;
import com.ericsson.em.emc.credential.serviceprovider.PasswordServiceProvider;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogContext;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogger;
import com.ericsson.lwac.security.session.Identity;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Singleton
public class CredentialManagerBean
implements CredentialManager {
    @EJB
    private CredentialDAO credentialDAO;
    @EJB
    private CredentialTypeDAO credentialTypeDAO;
    @EJB
    private CredentialHistoryDAO credentialHistoryDAO;
    private final ConcurrentHashMap<String, CredentialType> credentialTypes = new ConcurrentHashMap(2, 0.75f, 2);
    private final ConcurrentHashMap<Class<? extends CredentialOwner>, PasswordServiceProvider> passwordServiceProviders = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CredentialTypeProvider> credentialTypeProviders = new ConcurrentHashMap(2, 0.75f, 2);
    private final List<CredentialResetHandler> resetHandlers = new CopyOnWriteArrayList<CredentialResetHandler>();

    @Override
    public void registerPasswordServiceProvider(Class<? extends CredentialOwner> credentialOwner, PasswordServiceProvider provider) {
        this.passwordServiceProviders.put(credentialOwner, provider);
    }

    @Override
    public void registerCredentialTypeProvider(String credentialType, CredentialTypeProvider provider) {
        this.credentialTypeProviders.put(credentialType, provider);
    }

    private PasswordServiceProvider getPasswordServiceProvider(CredentialOwner credentialOwner) {
        return this.passwordServiceProviders.get(credentialOwner.getClass());
    }

    private CredentialTypeProvider getProvider(CredentialType credentialType) {
        if (credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        return this.getProvider(credentialType.getName());
    }

    private CredentialTypeProvider getProvider(String credentialType) {
        if (credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        CredentialTypeProvider credentialTypeProvider = this.credentialTypeProviders.get(credentialType);
        if (credentialTypeProvider == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIAL_TYPE_NOT_FOUND).create();
        }
        return credentialTypeProvider;
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, CredentialType credentialType, String credentialSecret) {
        return this.createCredential(credentialOwner, credentialType, credentialSecret, CredentialStatus.ACTIVE);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, CredentialType credentialType, String credentialSecret, String repeatedCredentialSecret) {
        return this.createCredential(credentialOwner, credentialType, credentialSecret, repeatedCredentialSecret, CredentialStatus.ACTIVE);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialTypeName, String credentialSecret) {
        return this.createCredential(credentialOwner, credentialTypeName, credentialSecret, CredentialStatus.ACTIVE);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialTypeName, String credentialSecret, String repeatedSecret) {
        return this.createCredential(credentialOwner, credentialTypeName, credentialSecret, repeatedSecret, CredentialStatus.ACTIVE);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialTypeName, String credentialSecret, CredentialStatus initialStatus) {
        CredentialType credentialType = this.getCredentialType(credentialTypeName);
        return this.createCredential(credentialOwner, credentialType, credentialSecret, initialStatus);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialTypeName, String credentialSecret, String repeatedCredentialSecret, CredentialStatus initialStatus) {
        CredentialType credentialType = this.getCredentialType(credentialTypeName);
        return this.createCredential(credentialOwner, credentialType, credentialSecret, repeatedCredentialSecret, initialStatus);
    }

    private Credential createCredential(CredentialOwner credentialOwner, CredentialType credentialType, String credentialSecret, String repeatedCredentialSecret, CredentialStatus initialStatus) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.createCredential(credentialOwner, credentialSecret, repeatedCredentialSecret, initialStatus);
    }

    private Credential createCredential(CredentialOwner credentialOwner, CredentialType credentialType, String credentialSecret, CredentialStatus initialStatus) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.createCredential(credentialOwner, credentialSecret, initialStatus);
    }

    @Override
    public Credential createVoidCredential(CredentialOwner credentialOwner, CredentialType credentialType) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.createVoidCredential(credentialOwner);
    }

    @Override
    public Credential createVoidCredential(CredentialOwner credentialOwner, CredentialType credentialType, CredentialStatus initialStatus) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.createVoidCredential(credentialOwner, initialStatus);
    }

    @Override
    public void resetCredential(CredentialOwner credentialOwner, String credentialType, String credentialSecret, String repeatedSecret, CredentialStatus newStatus) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        credentialTypeProvider.resetCredential(credentialOwner, credentialSecret, repeatedSecret, newStatus);
        for (CredentialResetHandler handler : this.resetHandlers) {
            handler.onReset(credentialOwner);
        }
    }

    @Override
    public void registerOnResetHandler(CredentialResetHandler handler) {
        this.resetHandlers.remove(handler);
        this.resetHandlers.add(handler);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="ChangePassword", flags={"forcelog"}, recordVersion=1)
    public Credential updateCredentialAndAuditLog(Identity auditLogIdentity, CredentialOwner credentialOwner, String credentialTypeName, String currentSecret, String newSecret, String repeatedSecret) {
        if (auditLogIdentity != null) {
            AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
            auditTrailLogger.initiatingUser(auditLogIdentity.getIdentifier());
        }
        if (currentSecret == null || newSecret == null) {
            throw new IllegalArgumentException("Missing secret.");
        }
        return this.updateCredential(credentialOwner, credentialTypeName, currentSecret, newSecret, repeatedSecret);
    }

    @Override
    public Credential updateCredential(CredentialOwner credentialOwner, String credentialTypeName, String currentSecret, String newSecret, String repeatedSecret) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialTypeName);
        return credentialTypeProvider.updateCredential(credentialOwner, currentSecret, newSecret, repeatedSecret);
    }

    @Override
    public List<Credential> getCredentialsByOwner(CredentialOwner credentialOwner) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        return this.credentialDAO.findByCredentialOwnerReference(credentialOwner.getCredentialOwnerReference());
    }

    @Override
    public Credential getCredentialByOwnerAndCredentialType(CredentialOwner credentialOwner, CredentialType credentialType) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        if (credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference());
    }

    @Override
    public Credential getCredentialByOwnerReferenceAndCredentialType(CredentialOwnerReference credentialOwnerReference, CredentialType credentialType) {
        if (credentialOwnerReference == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_OWNER_REFERENCE, "credentialOwnerReference");
        }
        if (credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        return this.credentialDAO.findByCredentialOwnerReferenceAndCredentialType(credentialOwnerReference, credentialType);
    }

    @Override
    public List<CredentialHistory> getLatestByCredentialOwnerAndCredentialType(CredentialOwner credentialOwner, CredentialType credentialType, int numOfEntries) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        if (credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        return this.credentialHistoryDAO.findLatestByCredentialOwnerAndCredentialType(credentialOwner, credentialType, numOfEntries);
    }

    @Override
    public Credential getCredentialByOwnerAndCredentialType(CredentialOwner credentialOwner, String credentialTypeName) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        if (credentialTypeName == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialType");
        }
        CredentialType credentialType = this.getCredentialType(credentialTypeName);
        if (credentialType == null) {
            return null;
        }
        return this.getCredentialByOwnerAndCredentialType(credentialOwner, credentialType);
    }

    @Override
    public CredentialType getCredentialType(String credentialTypeName) {
        CredentialType priorType;
        if (credentialTypeName == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialTypeName");
        }
        CredentialType credentialType = this.credentialTypes.get(credentialTypeName);
        if (credentialType == null && (credentialType = this.credentialTypeDAO.findByName(credentialTypeName)) != null && (priorType = this.credentialTypes.putIfAbsent(credentialTypeName, credentialType)) != null) {
            credentialType = priorType;
        }
        return credentialType;
    }

    @Override
    @RolesAllowed(value={"ROLE_LOCK_ANY_ACCESSCHANNEL"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="BlockCredential", flags={"forcelog"}, recordVersion=1)
    public Credential block(Credential credential, String userIdentity) {
        if (credential.getStatus() == CredentialStatus.INACTIVE) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_NOT_ACTIVE, new Object[0]);
        }
        AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
        auditTrailLogger.log("Identity", (Object)userIdentity);
        credential.setStatus(CredentialStatus.BLOCKED);
        credential.setSuspendedUntil(null);
        return this.credentialDAO.update(credential);
    }

    @Override
    @RolesAllowed(value={"ROLE_UNLOCK_ANY_ACCESSCHANNEL"})
    public Credential unblock(Credential credential) {
        if (credential.getStatus() == CredentialStatus.INACTIVE) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_NOT_BLOCKED, new Object[0]);
        }
        credential.setStatus(CredentialStatus.ACTIVE);
        credential.setLastFailedLogins(credential.getFailedLogins());
        credential.setFailedLogins(0);
        credential.setSuspendedUntil(null);
        return this.credentialDAO.update(credential);
    }

    @Override
    public Credential inactivate(Credential credential) {
        if (credential.getStatus() == CredentialStatus.ACTIVE) {
            credential.setStatus(CredentialStatus.INACTIVE);
            return this.credentialDAO.update(credential);
        }
        throw new CredentialException(CredentialErrorCode.CREDENTIAL_NOT_ACTIVE, new Object[0]);
    }

    @Override
    public Credential activate(Credential credential) {
        if (credential.getStatus() == CredentialStatus.INACTIVE) {
            credential.setStatus(CredentialStatus.ACTIVE);
            return this.credentialDAO.update(credential);
        }
        throw new CredentialException(CredentialErrorCode.CREDENTIAL_NOT_INACTIVE, new Object[0]);
    }

    @Override
    public void registerSuccessfulLogin(CredentialOwner credentialOwner, String credentialTypeName) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialTypeName);
        credentialTypeProvider.registerSuccessfulLogin(credentialOwner);
    }

    @Override
    public void registerUnsuccessfulLogin(CredentialOwner credentialOwner, String credentialTypeName) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialTypeName);
        credentialTypeProvider.registerUnsuccessfulLogin(credentialOwner);
    }

    @Override
    public void registerUnsuccessfulReset(CredentialOwner credentialOwner, String credentialTypeName) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialTypeName);
        credentialTypeProvider.registerUnsuccessfulReset(credentialOwner);
    }

    @Override
    public void validateSecret(CredentialOwner credentialOwner, String password) {
        PasswordServiceProvider provider = this.getPasswordServiceProvider(credentialOwner);
        if (provider == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_MISSING_PROVIDER, credentialOwner.getClass().getName());
        }
        provider.validatePassword(credentialOwner, password);
    }

    @Override
    public void validateSecretStrength(CredentialOwner credentialOwner, String password) {
        PasswordServiceProvider provider = this.getPasswordServiceProvider(credentialOwner);
        if (provider == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_MISSING_PROVIDER, credentialOwner.getClass().getName());
        }
        provider.validatePasswordStrength(password);
    }

    @Override
    public String generateRandomSecret(CredentialOwner credentialOwner) {
        PasswordServiceProvider provider = this.getPasswordServiceProvider(credentialOwner);
        if (provider == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_MISSING_PROVIDER, credentialOwner.getClass().getName());
        }
        return provider.generateRandomPassword();
    }

    @Override
    public boolean authenticate(CredentialOwner credentialOwner, Credential credential, String providedSecret) {
        CredentialType credentialType = this.credentialTypeDAO.find(credential.getCredentialTypeId());
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialType);
        return credentialTypeProvider.authenticate(credentialOwner, credential, providedSecret);
    }

    @Override
    public boolean authenticate(CredentialOwner credentialOwner, Credential credential, String credentialTypeName, String providedSecret) {
        CredentialTypeProvider credentialTypeProvider = this.getProvider(credentialTypeName);
        return credentialTypeProvider.authenticate(credentialOwner, credential, providedSecret);
    }
}

