/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential;

import com.ericsson.em.emc.credential.CredentialKeyDomainService;
import com.ericsson.lwac.cluster.ClusterChannel;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterMessage;
import com.ericsson.lwac.cluster.ClusterMessageListener;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.crypto.securitymodule.InspectableKeyDomain;
import com.ericsson.lwac.crypto.securitymodule.KeyDomain;
import com.ericsson.lwac.crypto.securitymodule.KeyInfo;
import com.ericsson.lwac.crypto.securitymodule.KeyManagement;
import com.ericsson.lwac.crypto.securitymodule.KeyStoreManager;
import com.ericsson.lwac.crypto.securitymodule.RolloverableKeyDomain;
import com.ericsson.lwac.crypto.securitymodule.entities.SecretKeyInfo;
import com.ericsson.lwac.crypto.securitymodule.persistence.SecurityModuleDBDAO;
import com.ericsson.lwac.crypto.securitymodule.persistence.SecurityModuleDBEntry;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceLifecycle;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.ericsson.lwac.deployer.service.ServiceStartException;
import com.ericsson.lwac.timer.TimerCondition;
import com.ericsson.lwac.timer.TimerListener;
import com.ericsson.lwac.timer.TimerRegistration;
import com.ericsson.lwac.timer.TimerService;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class CredentialKeyDomainServiceBean
implements CredentialKeyDomainService,
InspectableKeyDomain,
RolloverableKeyDomain,
ServiceLifecycle,
TimerListener {
    public static final String CRYPTO_PROVIDER = "SunJCE";
    public static final String CREDENTIAL_KEY_TYPE = "AES";
    public static final int CREDENTIAL_KEYLEN = 256;
    public static final Integer DEFAULT_PRIORITY = null;
    public static final String CREDENTIAL_KEY_NAME = "credential-key";
    protected static final String KEY_DOMAIN_CREDENTIAL = "credential";
    private static final Logger logger = LoggerFactory.getLogger(CredentialKeyDomainServiceBean.class.getPackage().getName());
    private String credentialKeyAliasBasename;
    private Integer credentialKeyGeneration;
    private String credentialKeyAlias;
    private String schedule;
    private Integer credentialKeyAge;
    private Integer priority = DEFAULT_PRIORITY;
    private ClusterChannel channel;
    @EJB
    private KeyManagement keyManagement;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ClusterService clusterService;
    @EJB
    private SecurityModuleDBDAO keyDAO;
    @Resource
    private KeyStoreManager keyStoreManager;
    @Resource
    private TimerService timerService;
    @Resource
    private TransactionManager transactionManager;

    @Override
    public String getCurrentCredentialKeyAlias() {
        return this.credentialKeyAlias;
    }

    @Override
    public String getCredentialKeyAliasWithGeneration(Integer generation) {
        if (generation == null) {
            return String.format("%s.%d", this.credentialKeyAliasBasename, 0);
        }
        return String.format("%s.%d", this.credentialKeyAliasBasename, generation);
    }

    @Override
    public Integer getCredentialKeyGeneration() {
        return this.credentialKeyGeneration;
    }

    public String getKeyDomain() {
        return KEY_DOMAIN_CREDENTIAL;
    }

    public List<KeyInfo> list() {
        ArrayList<KeyInfo> keyInfos = new ArrayList<KeyInfo>();
        List keyEntries = this.keyDAO.findAllGenerations(this.credentialKeyAliasBasename);
        for (SecurityModuleDBEntry entry : keyEntries) {
            SecretKeyInfo.SecretKeyInfoBuilder builder = SecretKeyInfo.builder();
            builder.keyDomain(KEY_DOMAIN_CREDENTIAL).alias(String.format("%s.%d", entry.getName(), entry.getGeneration())).algorithm(entry.getKeyAlgorithm());
            builder.creationDate(entry.getCreationTimestamp()).status(entry.getGeneration().equals(this.credentialKeyGeneration) ? KeyInfo.Status.Active : KeyInfo.Status.Retired);
            builder.keystore("dks");
            keyInfos.add((KeyInfo)builder.build());
        }
        return keyInfos;
    }

    public void rollover() {
        if (this.transactionManager.getTransaction().isPresent()) {
            this.transactionManager.afterCommit(transaction -> this.notifyKeyRollover());
        }
        try {
            Integer nextGeneration = this.credentialKeyGeneration + 1;
            String nextCredentialKeyAlias = String.format("%s.%d", this.credentialKeyAliasBasename, nextGeneration);
            KeyGenerator symmetricKeyGenerator = KeyGenerator.getInstance(CREDENTIAL_KEY_TYPE, CRYPTO_PROVIDER);
            symmetricKeyGenerator.init(256);
            SecretKey key = symmetricKeyGenerator.generateKey();
            KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(key);
            KeyStore keyStore = this.keyStoreManager.getKeyStore();
            keyStore.setEntry(nextCredentialKeyAlias, secretKeyEntry, null);
            this.credentialKeyAlias = nextCredentialKeyAlias;
            this.credentialKeyGeneration = nextGeneration;
            logger.info("Rolled over credential key, new key alias: {}", (Object)this.credentialKeyAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            logger.error("Failed to rollover credential key.", e);
            throw new RuntimeException("Failed to rollover credential key.", e);
        }
    }

    private void notifyKeyRollover() {
        try {
            logger.debug("Sending CredentialKeyRollOverMessage");
            this.clusterService.castMessage(this.channel, new CredentialKeyRollOverMessage(), ClusterService.CastOption.ASYNC);
        }
        catch (ClusterException | NotSerializableException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    @PostConstruct
    public void postConstruct() throws ClusterException {
        this.channel = this.clusterService.registerMessageListener(this.applicationContext.getBeanId(), new Receiver());
    }

    @Override
    public void start() throws ServiceStartException {
        try {
            this.setupCredentialKey();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new ServiceStartException("Failed to setup credential protection key", e);
        }
        if (this.schedule != null) {
            this.timerService.registerTimerListener(new TimerRegistration.TimerRegistrationBuilder().beanId(this.applicationContext.getBeanId()).timerListener(this).priority(this.priority).pattern(this.schedule).timerCondition(TimerCondition.ANY_NODE).build());
        }
        this.keyManagement.register((KeyDomain)this);
    }

    @Override
    public void onTimeout() {
        if (this.shouldRollover()) {
            this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> {
                this.rollover();
                return null;
            });
        }
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule == null || schedule.isEmpty() ? null : schedule;
    }

    @ServiceProperty
    public void setCredentialKeyAge(Integer age) {
        if (age < 0) {
            throw new IllegalArgumentException("KeyMasDays must be > 0 was " + this.credentialKeyAge);
        }
        this.credentialKeyAge = age;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupCredentialKey() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, ServiceStartException, CertificateException, IOException {
        this.credentialKeyAliasBasename = String.format("%s-%s", this.applicationContext.getApplicationName(), CREDENTIAL_KEY_NAME);
        SecurityModuleDBEntry keyEntry = this.keyDAO.findLatestGeneration(this.credentialKeyAliasBasename);
        if (keyEntry == null) {
            if (!this.clusterService.isCoordinator()) throw new ServiceStartException(String.format("Credential HMAC key %s not found.", this.credentialKeyAliasBasename));
            this.credentialKeyGeneration = 0;
            this.credentialKeyAlias = String.format("%s.%d", this.credentialKeyAliasBasename, this.credentialKeyGeneration);
            KeyGenerator symmetricKeyGenerator = KeyGenerator.getInstance(CREDENTIAL_KEY_TYPE, CRYPTO_PROVIDER);
            symmetricKeyGenerator.init(256);
            SecretKey key = symmetricKeyGenerator.generateKey();
            KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(key);
            KeyStore keyStore = this.keyStoreManager.getKeyStore();
            keyStore.setEntry(this.credentialKeyAlias, secretKeyEntry, null);
            return;
        } else {
            this.credentialKeyGeneration = keyEntry.getGeneration();
            this.credentialKeyAlias = String.format("%s.%d", this.credentialKeyAliasBasename, this.credentialKeyGeneration);
        }
    }

    @ServiceProperty
    public void setCredentialKeyAlias(String baseAlias) {
        this.credentialKeyAliasBasename = baseAlias == null || baseAlias.length() == 0 ? null : baseAlias;
    }

    @ServiceProperty
    public void setPriority(String priority) {
        this.priority = priority.trim().isEmpty() ? null : Integer.valueOf(priority);
    }

    private boolean shouldRollover() {
        SecurityModuleDBEntry keyEntry = this.keyDAO.findLatestGeneration(this.credentialKeyAliasBasename);
        DateTime keyCreation = new DateTime(keyEntry.getCreationTimestamp());
        return keyCreation.plusDays(this.credentialKeyAge).isBeforeNow();
    }

    private static class CredentialKeyRollOverMessage
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private CredentialKeyRollOverMessage() {
        }
    }

    private class Receiver
    implements ClusterMessageListener {
        private Receiver() {
        }

        @Override
        public Object handle(ClusterMessage message) {
            if (message.getPayload() instanceof CredentialKeyRollOverMessage) {
                logger.debug("Received CredentialKeyRollOverMessage");
                SecurityModuleDBEntry keyEntry = CredentialKeyDomainServiceBean.this.keyDAO.findLatestGeneration(CredentialKeyDomainServiceBean.this.credentialKeyAliasBasename);
                CredentialKeyDomainServiceBean.this.credentialKeyGeneration = keyEntry.getGeneration();
                CredentialKeyDomainServiceBean.this.credentialKeyAlias = String.format("%s.%d", CredentialKeyDomainServiceBean.this.credentialKeyAliasBasename, CredentialKeyDomainServiceBean.this.credentialKeyGeneration);
                logger.info("Credential key updated, new key alias: {}", (Object)CredentialKeyDomainServiceBean.this.credentialKeyAlias);
            }
            return null;
        }
    }
}

