/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.certificate;

import com.ericsson.em.emc.certificate.Certificate;
import com.ericsson.em.emc.certificate.CertificateDAO;
import com.ericsson.em.emc.certificate.CertificateManager;
import com.ericsson.lwac.database.persistence.ExtendedBaseEntityDAOBean;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

@Singleton
public class CertificateManagerBean
implements CertificateManager {
    private static final String HASH_ALGORITHM = "SHA-1";
    @EJB
    private CertificateDAO certificateDAO;

    @Override
    public Certificate createCertificate(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException {
        if (null != certificate) {
            Certificate certificateObject = this.getCertificate(certificate);
            return this.certificateDAO.create(certificateObject);
        }
        return null;
    }

    private Certificate getCertificate(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException {
        Certificate certificateObject = new Certificate();
        byte[] encodedCertificate = certificate.getEncoded();
        certificateObject.setCertificate(encodedCertificate);
        certificateObject.setHashedCertificate(this.getHashedCertificate(certificate));
        certificateObject.setExpiryTime(ExtendedBaseEntityDAOBean.getTimestamp((Date)certificate.getNotAfter()));
        return certificateObject;
    }

    @Override
    public void deleteCertificate(long id) {
        Certificate certificate = this.certificateDAO.find(id);
        if (null != certificate) {
            this.certificateDAO.delete(certificate);
        }
    }

    @Override
    public byte[] getHashedCertificate(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException {
        byte[] hash = null;
        MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
        hash = messageDigest.digest(certificate.getEncoded());
        return hash;
    }

    @Override
    public Certificate find(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException {
        byte[] hashedCertificate = this.getHashedCertificate(certificate);
        return this.certificateDAO.findbyHashedCertificate(hashedCertificate);
    }

    @Override
    public X509Certificate find(long id) throws CertificateException {
        return this.find(id, true);
    }

    @Override
    public X509Certificate find(long id, boolean checkValidity) throws CertificateException {
        Certificate certificate = this.certificateDAO.find(id);
        if (null == certificate) {
            throw new CertificateException("certificate not found.");
        }
        byte[] rawContent = certificate.getCertificate();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(rawContent);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        if (checkValidity) {
            cert.checkValidity();
        }
        return cert;
    }
}

