/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.audittrail.comparator.impl;

import com.ericsson.em.emc.audittrail.comparator.Comparator;
import com.ericsson.em.emc.audittrail.comparator.ReflectionComparator;
import com.ericsson.em.emc.m3externallog.json.comparator.ChangeField;
import com.ericsson.em.emc.m3externallog.json.comparator.Difference;
import com.ericsson.lwac.database.persistence.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CollectionComparator
implements Comparator {
    private final java.util.Comparator<BaseEntity> baseEntityComparator = this.createBaseEntityComparator();

    @Override
    public boolean canCompare(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return left instanceof Collection && right instanceof Collection;
    }

    @Override
    public Difference compare(Object left, Object right, ReflectionComparator reflectionComparator) {
        Difference difference = new Difference();
        Collection beforeList = (Collection)left;
        Collection afterList = (Collection)right;
        Iterator itBefore = beforeList.iterator();
        ArrayList<Object> removeList = new ArrayList<Object>();
        ArrayList<Object> addList = new ArrayList<Object>();
        ArrayList<Object> updatedBeforeList = new ArrayList<Object>();
        ArrayList<Object> updatedAfterList = new ArrayList<Object>();
        while (itBefore.hasNext()) {
            Object obj = itBefore.next();
            if (!afterList.contains(obj)) {
                removeList.add(obj);
                continue;
            }
            updatedBeforeList.add(obj);
        }
        for (Object obj : afterList) {
            if (!beforeList.contains(obj)) {
                addList.add(obj);
                continue;
            }
            updatedAfterList.add(obj);
        }
        if (!removeList.isEmpty()) {
            if (this.isBaseEntityList(removeList)) {
                List<BaseEntity> entitydRemoveList = this.toBaseEntity(removeList);
                for (BaseEntity entity : entitydRemoveList) {
                    difference.getChangeFields().add(this.createEntityChangeFields(entity, entity, null));
                }
            } else {
                difference.getChangeFields().add(new ChangeField(removeList, null));
            }
        }
        if (!addList.isEmpty()) {
            if (this.isBaseEntityList(addList)) {
                List<BaseEntity> entityList = this.toBaseEntity(addList);
                for (BaseEntity entity : entityList) {
                    difference.getChangeFields().add(this.createEntityChangeFields(entity, null, entity));
                }
            } else {
                difference.getChangeFields().add(new ChangeField(null, addList));
            }
        }
        if (!updatedBeforeList.isEmpty() && updatedBeforeList.size() == updatedAfterList.size() && this.isBaseEntityList(updatedBeforeList)) {
            List<BaseEntity> entitydBeforeList = this.toBaseEntity(updatedBeforeList);
            List<BaseEntity> entitydAfterList = this.toBaseEntity(updatedAfterList);
            Collections.sort(entitydBeforeList, this.baseEntityComparator);
            Collections.sort(entitydAfterList, this.baseEntityComparator);
            Iterator<BaseEntity> itBaseEntityBefore = entitydBeforeList.iterator();
            Iterator<BaseEntity> itBaseEntityAfter = entitydAfterList.iterator();
            while (itBaseEntityBefore.hasNext() && itBaseEntityAfter.hasNext()) {
                BaseEntity entityAfter;
                BaseEntity entityBefore = itBaseEntityBefore.next();
                Difference fieldDifference = reflectionComparator.compare(entityBefore, entityAfter = itBaseEntityAfter.next());
                if (fieldDifference.isEmpty()) continue;
                difference.getChangeFields().addAll(fieldDifference.getChangeFields());
            }
        }
        return difference;
    }

    private ChangeField createEntityChangeFields(BaseEntity entity, String fieldName, Object before, Object after) {
        return new ChangeField(entity.getId(), this.getClassName(entity), fieldName, before, after);
    }

    private ChangeField createEntityChangeFields(BaseEntity entity, Object before, Object after) {
        return this.createEntityChangeFields(entity, null, before, after);
    }

    private <T> String getClassName(T before) {
        return before.getClass().getSimpleName();
    }

    private List<BaseEntity> toBaseEntity(List<Object> updatedBeforeList) {
        ArrayList<BaseEntity> entityBeforeList = new ArrayList<BaseEntity>();
        for (Object obj : updatedBeforeList) {
            entityBeforeList.add((BaseEntity)obj);
        }
        return entityBeforeList;
    }

    private boolean isBaseEntityList(List<Object> updatedBeforeList) {
        boolean isBaseEntity = false;
        Iterator<Object> itUpdatedBefore = updatedBeforeList.iterator();
        if (itUpdatedBefore.hasNext()) {
            Object obj = itUpdatedBefore.next();
            isBaseEntity = obj instanceof BaseEntity;
        }
        return isBaseEntity;
    }

    private java.util.Comparator<BaseEntity> createBaseEntityComparator() {
        return new java.util.Comparator<BaseEntity>(this){

            @Override
            public int compare(BaseEntity o1, BaseEntity o2) {
                if (o1.getId() == null) {
                    return -1;
                }
                if (o2.getId() == null) {
                    return 1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        };
    }
}

