/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.activator;

import com.ericsson.em.emc.activator.ProfileServiceActivationManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileServiceActivationManagerBean
implements ProfileServiceActivationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileServiceActivationManagerBean.class);
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @EJB
    private ProfileDAO profileDAO;
    private static final String SERVICE_PERMISSIONS = "Permissions";
    private static final String ROLE_VIEW_ANY_APPROVALS = "ROLE_VIEW_ANY_APPROVALS";
    private static final String ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS = "ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS";

    @Override
    public void insertIntoProfileServicesWithNewAdminPermission() {
        List<Profile> profiles = this.profileDAO.findByPermission(ROLE_VIEW_ANY_APPROVALS);
        for (Profile profile : profiles) {
            Optional<ProfileService> serviceParent = profile.getServices().stream().filter(x -> x.getName().equals(SERVICE_PERMISSIONS)).findFirst();
            if (!serviceParent.isPresent()) continue;
            ProfileService serviceChild = new ProfileService(ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS);
            this.profileServiceDAO.create(serviceChild, serviceParent.get());
        }
    }
}

