/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractSingleDataItem;

public class BooleanDataItem
extends AbstractSingleDataItem {
    private boolean myValue;

    public BooleanDataItem(boolean value) {
        super(value ? Boolean.TRUE : Boolean.FALSE);
        this.myValue = value;
    }

    public BooleanDataItem(String value) {
        super("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE);
        this.myValue = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    @Override
    public Object getDataItem(Object reference) {
        return this.myValue ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object getDataItem() {
        return this.myValue ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        String value;
        Boolean oldValue = new Boolean(this.getValue());
        this.myValue = object instanceof Boolean ? (Boolean)object : "true".equalsIgnoreCase(value = object.toString()) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        this.notify(reference, oldValue);
    }

    @Override
    public void setDataItem(Object object) {
        this.setDataItem(null, object);
    }

    @Override
    protected boolean performSetDataItem(Object reference, Object object) {
        String value;
        this.myValue = object instanceof Boolean ? (Boolean)object : "true".equalsIgnoreCase(value = object.toString()) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        return true;
    }

    public boolean getValue() {
        return this.myValue;
    }

    public void setValue(boolean value) {
        this.setDataItem(null, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setValue(String value) {
        this.setDataItem(null, value);
    }

    private void notify(Object reference, Object oldObject) {
        if (this.myListeners != null) {
            if (reference == null) {
                this.myListeners.firePropertyChange("null", oldObject, this.getDataItem(reference));
            } else {
                this.myListeners.firePropertyChange(reference.toString(), oldObject, this.getDataItem(reference));
            }
        }
    }
}

